/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;

public abstract class TimedWaitCondition
extends ScheduleWaitCondition {
    protected void requestDisplayIfNecessary(CompoundTag context, int time) {
        int ticksUntilDeparture = this.totalWaitTicks() - time;
        if (ticksUntilDeparture < 1200 && ticksUntilDeparture % 100 == 0) {
            this.requestStatusToUpdate(context);
        }
        if (ticksUntilDeparture >= 1200 && ticksUntilDeparture % 1200 == 0) {
            this.requestStatusToUpdate(context);
        }
    }

    public int totalWaitTicks() {
        return this.getValue() * this.getUnit().ticksPer;
    }

    public TimedWaitCondition(Identifier id) {
        super(id);
        this.data.putInt("Value", 5);
        this.data.putInt("TimeUnit", TimeUnit.SECONDS.ordinal());
    }

    public int getValue() {
        return this.intData("Value");
    }

    public TimeUnit getUnit() {
        return this.enumData("TimeUnit", TimeUnit.class);
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int time = tag.getIntOr("Time", 0);
        int ticksUntilDeparture = this.totalWaitTicks() - time;
        boolean showInMinutes = ticksUntilDeparture >= 1200;
        int num = (int)(showInMinutes ? Math.floor((float)ticksUntilDeparture / 1200.0f) : Math.ceil((float)ticksUntilDeparture / 100.0f) * 5.0);
        String key = "generic." + (showInMinutes ? (num == 1 ? "daytime.minute" : "unit.minutes") : (num == 1 ? "daytime.second" : "unit.seconds"));
        return Component.translatable((String)("create.schedule.condition." + this.id.getPath() + ".status"), (Object[])new Object[]{Component.literal((String)(num + " ")).append((Component)Component.translatable((String)("create." + key)))});
    }

    public static enum TimeUnit {
        TICKS(1, "t"),
        SECONDS(20, "s"),
        MINUTES(1200, "min");

        public final int ticksPer;
        public final String suffix;

        private TimeUnit(int ticksPer, String suffix) {
            this.ticksPer = ticksPer;
            this.suffix = suffix;
        }
    }
}

