/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.destination;

import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DeliverPackagesInstruction
extends ScheduleInstruction {
    public DeliverPackagesInstruction(Identifier id) {
        super(id);
    }

    @Override
    public boolean supportsConditions() {
        return true;
    }

    @Override
    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, Level level) {
        boolean anyMatch = false;
        String firstPackage = null;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = runtime.train;
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            runtime.startCooldown();
            return null;
        }
        for (Carriage carriage : train.carriages) {
            CombinedInvWrapper carriageInventory = carriage.storage.getAllItems();
            if (carriageInventory == null) continue;
            Iterator iterator = carriageInventory.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!PackageItem.isPackage(stack)) continue;
                if (firstPackage == null) {
                    firstPackage = PackageItem.getAddress(stack);
                }
                block2: for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
                    for (Map.Entry<BlockPos, GlobalPackagePort> port : globalStation.connectedPorts.entrySet()) {
                        if (!PackageItem.matchAddress(stack, port.getValue().address)) continue;
                        anyMatch = true;
                        validStations.add(globalStation);
                        continue block2;
                    }
                }
            }
        }
        if (validStations.isEmpty()) {
            if (firstPackage != null) {
                train.status.failedPackageNoTarget(firstPackage);
                runtime.startCooldown();
            } else {
                runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ++runtime.currentEntry;
            }
            return null;
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            }
            runtime.startCooldown();
            return null;
        }
        return best;
    }
}

