/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.destination;

import com.zurrtum.create.catnip.data.Glob;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime;
import com.zurrtum.create.content.trains.schedule.destination.TextScheduleInstruction;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FetchPackagesInstruction
extends TextScheduleInstruction {
    public FetchPackagesInstruction(Identifier id) {
        super(id);
    }

    public String getFilter() {
        return this.getLabelText();
    }

    public String getFilterForRegex() {
        if (this.getFilter().isBlank()) {
            return Glob.toRegexPattern("*", "");
        }
        return Glob.toRegexPattern(this.getFilter(), "");
    }

    @Override
    public boolean supportsConditions() {
        return true;
    }

    @Override
    public DiscoveredPath start(ScheduleRuntime runtime, Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return null;
        }
        String regex = this.getFilterForRegex();
        boolean anyMatch = false;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = runtime.train;
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            runtime.startCooldown();
            return null;
        }
        for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
            ServerLevel dimLevel = server.getLevel(globalStation.blockEntityDimension);
            if (dimLevel == null) continue;
            for (Map.Entry<BlockPos, GlobalPackagePort> entry : globalStation.connectedPorts.entrySet()) {
                BlockEntity blockEntity;
                GlobalPackagePort port = entry.getValue();
                BlockPos pos = entry.getKey();
                ItemInventory postboxInventory = port.offlineBuffer;
                if (dimLevel.isLoaded(pos) && (blockEntity = dimLevel.getBlockEntity(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)blockEntity;
                    postboxInventory = ppbe.inventory;
                }
                Iterator iterator = postboxInventory.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = (ItemStack)iterator.next();
                    if (!PackageItem.isPackage(stack) || PackageItem.matchAddress(stack, port.address)) continue;
                    try {
                        if (!PackageItem.getAddress(stack).matches(regex)) continue;
                        anyMatch = true;
                        validStations.add(globalStation);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {}
                }
            }
        }
        if (validStations.isEmpty()) {
            runtime.startCooldown();
            runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
            ++runtime.currentEntry;
            return null;
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            }
            runtime.startCooldown();
            return null;
        }
        return best;
    }
}

