/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.destination;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllSchedules;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime;
import com.zurrtum.create.content.trains.schedule.destination.NbtReadContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueInputContextHelper;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class ScheduleInstruction
extends ScheduleDataEntry {
    public static final StreamCodec<RegistryFriendlyByteBuf, ScheduleInstruction> STREAM_CODEC = StreamCodec.of(ScheduleInstruction::encode, ScheduleInstruction::decode);

    public ScheduleInstruction(Identifier id) {
        super(id);
    }

    public abstract boolean supportsConditions();

    @Nullable
    public abstract DiscoveredPath start(ScheduleRuntime var1, Level var2);

    public final void write(ValueOutput view) {
        view.store("Id", Identifier.CODEC, (Object)this.id);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleInstruction", Create.LOGGER);){
            TagValueOutput writeView = new TagValueOutput((ProblemReporter)logging, ((TagValueOutput)view).ops, this.data);
            this.writeAdditional((ValueOutput)writeView);
            view.store("Data", CompoundTag.CODEC, (Object)writeView.buildResult());
        }
    }

    public static <T> DataResult<T> encode(ScheduleInstruction input, DynamicOps<T> ops, T empty) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Id", (Object)input.id, (Encoder)Identifier.CODEC);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleInstruction", Create.LOGGER);){
            TagValueOutput view = new TagValueOutput((ProblemReporter)logging, ops, input.data);
            input.writeAdditional((ValueOutput)view);
            map.add("Data", (Object)view.buildResult(), (Encoder)CompoundTag.CODEC);
        }
        return map.build(empty);
    }

    public static ScheduleInstruction read(ValueInput view) {
        Identifier location = view.read("Id", Identifier.CODEC).orElse(null);
        ScheduleInstruction scheduleDestination = AllSchedules.createScheduleInstruction(location);
        if (scheduleDestination == null) {
            return ScheduleInstruction.fallback(location);
        }
        ValueInput data = view.childOrEmpty("Data");
        scheduleDestination.readAdditional(data);
        scheduleDestination.data = view.read("Data", CompoundTag.CODEC).orElseGet(CompoundTag::new);
        return scheduleDestination;
    }

    public static <T> ScheduleInstruction decode(DynamicOps<T> ops, T input) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        Identifier location = (Identifier)Identifier.CODEC.parse(ops, map.get("Id")).getOrThrow();
        ScheduleInstruction scheduleDestination = AllSchedules.createScheduleInstruction(location);
        if (scheduleDestination == null) {
            return ScheduleInstruction.fallback(location);
        }
        scheduleDestination.data = CompoundTag.CODEC.parse(ops, map.get("Data")).result().orElseGet(CompoundTag::new);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleInstruction", Create.LOGGER);){
            TagValueInput view = new TagValueInput((ProblemReporter)logging, (ValueInputContextHelper)new NbtReadContext(ops), scheduleDestination.data);
            scheduleDestination.readAdditional((ValueInput)view);
        }
        return scheduleDestination;
    }

    private static ScheduleInstruction fallback(Identifier location) {
        Create.LOGGER.warn("Could not parse schedule instruction type: {}", (Object)location);
        return AllSchedules.createScheduleInstruction(AllSchedules.DESTINATION);
    }

    private static void encode(RegistryFriendlyByteBuf buf, ScheduleInstruction value) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleInstruction", Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)buf.registryAccess());
            value.write((ValueOutput)view);
            buf.writeNbt((Tag)view.buildResult());
        }
    }

    private static ScheduleInstruction decode(RegistryFriendlyByteBuf buf) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleInstruction", Create.LOGGER);){
            ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)buf.registryAccess(), (CompoundTag)buf.readNbt());
            ScheduleInstruction scheduleInstruction = ScheduleInstruction.read(view);
            return scheduleInstruction;
        }
    }
}

