/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.signal.SignalBlock;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignalBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public TrackTargetingBehaviour<SignalBoundary> edgePoint;
    private SignalState state = SignalState.INVALID;
    private OverlayState overlay = OverlayState.SKIP;
    private int switchToRedAfterTrainEntered;
    private boolean lastReportedPower = false;

    public SignalBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.TRACK_SIGNAL, pos, state);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.store("State", SignalState.CODEC, (Object)this.state);
        view.store("Overlay", OverlayState.CODEC, (Object)this.overlay);
        view.putBoolean("Power", this.lastReportedPower);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.state = view.read("State", SignalState.CODEC).orElse(SignalState.RED);
        this.overlay = view.read("Overlay", OverlayState.CODEC).orElse(OverlayState.RENDER);
        this.lastReportedPower = view.getBooleanOr("Power", false);
        this.invalidateRenderBoundingBox();
    }

    @Nullable
    public SignalBoundary getSignal() {
        return this.edgePoint.getEdgePoint();
    }

    public boolean isPowered() {
        return this.state == SignalState.RED;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<SignalBoundary>(this, EdgePointType.SIGNAL);
        behaviours.add(this.edgePoint);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        SignalBoundary boundary = this.getSignal();
        if (boundary == null) {
            this.enterState(SignalState.INVALID);
            this.setOverlay(OverlayState.RENDER);
            return;
        }
        BlockState blockState = this.getBlockState();
        blockState.getOptionalValue((Property)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            boundary.updateBlockEntityPower(this);
            this.notifyUpdate();
        });
        blockState.getOptionalValue(SignalBlock.TYPE).ifPresent(stateType -> {
            SignalBlock.SignalType targetType = boundary.getTypeFor(this.worldPosition);
            if (stateType != targetType) {
                this.level.setBlock(this.worldPosition, (BlockState)blockState.setValue(SignalBlock.TYPE, (Comparable)((Object)targetType)), 3);
                this.refreshBlockState();
            }
        });
        this.enterState(boundary.getStateFor(this.worldPosition));
        this.setOverlay(boundary.getOverlayFor(this.worldPosition));
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public SignalState getState() {
        return this.state;
    }

    public OverlayState getOverlay() {
        return this.overlay;
    }

    public void setOverlay(OverlayState state) {
        if (this.overlay == state) {
            return;
        }
        this.overlay = state;
        this.notifyUpdate();
    }

    public void enterState(SignalState state) {
        if (this.switchToRedAfterTrainEntered > 0) {
            --this.switchToRedAfterTrainEntered;
        }
        if (this.state == state) {
            return;
        }
        if (state == SignalState.RED && this.switchToRedAfterTrainEntered > 0) {
            return;
        }
        this.state = state;
        this.switchToRedAfterTrainEntered = state == SignalState.GREEN || state == SignalState.YELLOW ? 15 : 0;
        this.notifyUpdate();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(Vec3.atLowerCornerOf((Vec3i)this.worldPosition), Vec3.atLowerCornerOf((Vec3i)this.edgePoint.getGlobalPosition())).inflate(2.0);
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public static enum SignalState implements StringRepresentable
    {
        RED,
        YELLOW,
        GREEN,
        INVALID;

        public static final Codec<SignalState> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isRedLight(float renderTime) {
            return this == RED || this == INVALID && renderTime % 40.0f < 3.0f;
        }

        public boolean isYellowLight(float renderTime) {
            return this == YELLOW;
        }

        public boolean isGreenLight(float renderTime) {
            return this == GREEN;
        }

        static {
            CODEC = StringRepresentable.fromEnum(SignalState::values);
        }
    }

    public static enum OverlayState implements StringRepresentable
    {
        RENDER,
        SKIP,
        DUAL;

        public static final Codec<OverlayState> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(OverlayState::values);
        }
    }
}

