/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class SingleBlockEntityEdgePoint
extends TrackEdgePoint {
    public ResourceKey<Level> blockEntityDimension;
    public BlockPos blockEntityPos;

    public BlockPos getBlockEntityPos() {
        return this.blockEntityPos;
    }

    public ResourceKey<Level> getBlockEntityDimension() {
        return this.blockEntityDimension;
    }

    @Override
    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        this.blockEntityPos = blockEntity.getBlockPos();
        this.blockEntityDimension = blockEntity.getLevel().dimension();
    }

    @Override
    public void blockEntityRemoved(MinecraftServer server, BlockPos blockEntityPos, boolean front) {
        this.removeFromAllGraphs(server);
    }

    @Override
    public void invalidate(LevelAccessor level) {
        this.invalidateAt(level, this.blockEntityPos);
    }

    @Override
    public boolean canMerge() {
        return false;
    }

    @Override
    public void read(ValueInput view, boolean migration, DimensionPalette dimensions) {
        super.read(view, migration, dimensions);
        if (migration) {
            return;
        }
        this.blockEntityPos = view.read("BlockEntityPos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        this.blockEntityDimension = (ResourceKey)view.read("BlockEntityDimension", (Codec)dimensions).orElseThrow();
    }

    @Override
    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        super.decode(ops, input, migration, dimensions);
        if (migration) {
            return;
        }
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.blockEntityPos = BlockPos.CODEC.parse(ops, map.get("BlockEntityPos")).result().orElse(BlockPos.ZERO);
        this.blockEntityDimension = (ResourceKey)dimensions.parse(ops, map.get("BlockEntityDimension")).getOrThrow();
    }

    @Override
    public void write(ValueOutput view, DimensionPalette dimensions) {
        super.write(view, dimensions);
        view.store("BlockEntityPos", BlockPos.CODEC, (Object)this.blockEntityPos);
        view.store("BlockEntityDimension", (Codec)dimensions, this.blockEntityDimension);
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        DataResult<T> prefix = super.encode(ops, empty, dimensions);
        RecordBuilder map = ops.mapBuilder();
        map.add("BlockEntityPos", (Object)this.blockEntityPos, (Encoder)BlockPos.CODEC);
        map.add("BlockEntityDimension", this.blockEntityDimension, (Encoder)dimensions);
        return map.build(prefix);
    }
}

