/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class TrackEdgePoint {
    public UUID id;
    public Couple<TrackNodeLocation> edgeLocation;
    public double position;
    private EdgePointType<?> type;

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public void setType(EdgePointType<?> type) {
        this.type = type;
    }

    public EdgePointType<?> getType() {
        return this.type;
    }

    public abstract boolean canMerge();

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return false;
    }

    public abstract void invalidate(LevelAccessor var1);

    protected void invalidateAt(LevelAccessor level, BlockPos blockEntityPos) {
        TrackTargetingBehaviour<?> behaviour = BlockEntityBehaviour.get((BlockGetter)level, blockEntityPos, TrackTargetingBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "TrackEdgePoint", Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)level.registryAccess());
            DimensionPalette dimensions = new DimensionPalette();
            this.write((ValueOutput)view, dimensions);
            view.store("DimensionPalette", DimensionPalette.CODEC, (Object)dimensions);
            behaviour.invalidateEdgePoint(view.buildResult());
        }
    }

    public abstract void blockEntityAdded(BlockEntity var1, boolean var2);

    public abstract void blockEntityRemoved(MinecraftServer var1, BlockPos var2, boolean var3);

    public void onRemoved(MinecraftServer server, TrackGraph graph) {
    }

    public void setLocation(Couple<TrackNodeLocation> nodes, double position) {
        this.edgeLocation = nodes;
        this.position = position;
    }

    public double getLocationOn(TrackEdge edge) {
        return this.isPrimary(edge.node1) ? edge.getLength() - this.position : this.position;
    }

    public boolean canNavigateVia(TrackNode side) {
        return true;
    }

    public boolean isPrimary(TrackNode node1) {
        return ((TrackNodeLocation)((Object)this.edgeLocation.getSecond())).equals((Object)node1.getLocation());
    }

    public void read(ValueInput view, boolean migration, DimensionPalette dimensions) {
        if (migration) {
            return;
        }
        this.id = (UUID)view.read("Id", UUIDUtil.CODEC).orElseThrow();
        this.position = view.getDoubleOr("Position", 0.0);
        Iterator edge = view.childrenListOrEmpty("Edge").iterator();
        this.edgeLocation = Couple.create(TrackNodeLocation.read((ValueInput)edge.next(), dimensions), TrackNodeLocation.read((ValueInput)edge.next(), dimensions));
    }

    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        if (migration) {
            return;
        }
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.id = (UUID)((Pair)UUIDUtil.CODEC.decode(ops, map.get("Id")).getOrThrow()).getFirst();
        this.position = ops.getNumberValue(map.get("Position"), (Number)0).doubleValue();
        this.edgeLocation = Couple.create(null, null);
        ((Consumer)ops.getList(map.get("Edge")).getOrThrow()).accept(item -> {
            TrackNodeLocation location = TrackNodeLocation.decode(ops, item, dimensions);
            if (this.edgeLocation.getFirst() == null) {
                this.edgeLocation.setFirst(location);
            } else {
                this.edgeLocation.setSecond(location);
            }
        });
    }

    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        this.id = buffer.readUUID();
        this.edgeLocation = Couple.create(() -> TrackNodeLocation.receive(buffer, dimensions));
        this.position = buffer.readDouble();
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        view.store("Id", UUIDUtil.CODEC, (Object)this.id);
        view.putDouble("Position", this.position);
        ValueOutput.ValueOutputList edge = view.childrenList("Edge");
        ((TrackNodeLocation)((Object)this.edgeLocation.getFirst())).write(edge.addChild(), dimensions);
        ((TrackNodeLocation)((Object)this.edgeLocation.getSecond())).write(edge.addChild(), dimensions);
    }

    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Id", (Object)this.id, (Encoder)UUIDUtil.CODEC);
        map.add("Position", ops.createDouble(this.position));
        ListBuilder edge = ops.listBuilder();
        edge.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)this.edgeLocation.getFirst()), ops, empty, dimensions));
        edge.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)this.edgeLocation.getSecond()), ops, empty, dimensions));
        map.add("Edge", edge.build(empty));
        return map.build(empty);
    }

    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        buffer.writeIdentifier(this.type.getId());
        buffer.writeUUID(this.id);
        this.edgeLocation.forEach(loc -> loc.send(buffer, dimensions));
        buffer.writeDouble(this.position);
    }

    public void tick(MinecraftServer server, TrackGraph graph, boolean preTrains) {
    }

    protected void removeFromAllGraphs(MinecraftServer server) {
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
            if (trackGraph.removePoint(server, this.getType(), this.id) == null) continue;
            return;
        }
    }
}

