/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.station;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class GlobalStation
extends SingleBlockEntityEdgePoint {
    public static final Codec<Map<BlockPos, GlobalPackagePort>> PORTS_CODEC = CreateCodecs.getCodecMap(BlockPos.CODEC, GlobalPackagePort.CODEC);
    public String name = "Track Station";
    public WeakReference<Train> nearestTrain = new WeakReference<Object>(null);
    public boolean assembling;
    public Map<BlockPos, GlobalPackagePort> connectedPorts = new HashMap<BlockPos, GlobalPackagePort>();

    @Override
    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        BlockState state = blockEntity.getBlockState();
        this.assembling = state != null && state.hasProperty((Property)StationBlock.ASSEMBLING) && (Boolean)state.getValue((Property)StationBlock.ASSEMBLING) != false;
    }

    @Override
    public void read(ValueInput view, boolean migration, DimensionPalette dimensions) {
        super.read(view, migration, dimensions);
        this.name = view.getStringOr("Name", "");
        this.assembling = view.getBooleanOr("Assembling", false);
        this.nearestTrain = new WeakReference<Object>(null);
        view.read("Ports", PORTS_CODEC).ifPresentOrElse(ports -> {
            this.connectedPorts = ports;
        }, this.connectedPorts::clear);
    }

    @Override
    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        super.decode(ops, input, migration, dimensions);
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.name = ops.getStringValue(map.get("Name")).result().orElse("");
        this.assembling = (Boolean)ops.getBooleanValue(map.get("Assembling")).getOrThrow();
    }

    @Override
    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.name = buffer.readUtf();
        this.assembling = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.readBlockPos();
        }
    }

    @Override
    public void write(ValueOutput view, DimensionPalette dimensions) {
        super.write(view, dimensions);
        view.putString("Name", this.name);
        view.putBoolean("Assembling", this.assembling);
        view.store("Ports", PORTS_CODEC, this.connectedPorts);
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        DataResult<T> prefix = super.encode(ops, empty, dimensions);
        RecordBuilder map = ops.mapBuilder();
        map.add("Name", ops.createString(this.name));
        map.add("Assembling", ops.createBoolean(this.assembling));
        map.add("Ports", this.connectedPorts, PORTS_CODEC);
        return map.build(prefix);
    }

    @Override
    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.writeUtf(this.name);
        buffer.writeBoolean(this.assembling);
        buffer.writeBoolean(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.writeBlockPos(this.blockEntityPos);
        }
    }

    public boolean canApproachFrom(TrackNode side) {
        return this.isPrimary(side) && !this.assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !this.assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination) {
            this.nearestTrain = new WeakReference<Train>(train);
        }
    }

    public void cancelReservation(Train train) {
        if (this.nearestTrain.get() == train) {
            this.nearestTrain = new WeakReference<Object>(null);
        }
    }

    public void trainDeparted(Train train) {
        this.cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null) {
            return nearestTrain;
        }
        if (nearestTrain.getCurrentStation() == this) {
            return nearestTrain;
        }
        if (!nearestTrain.navigation.isActive()) {
            return null;
        }
        if (nearestTrain.navigation.distanceToDestination > 30.0) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return (Train)this.nearestTrain.get();
    }

    public void runMailTransfer() {
        Train train = this.getPresentTrain();
        if (train == null || this.connectedPorts.isEmpty()) {
            return;
        }
        MinecraftServer server = Create.SERVER;
        ServerLevel level = server.getLevel(this.getBlockEntityDimension());
        for (Carriage carriage : train.carriages) {
            CombinedInvWrapper carriageInventory = carriage.storage.getAllItems();
            if (carriageInventory == null) continue;
            for (Map.Entry<BlockPos, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                BlockEntity blockEntity;
                GlobalPackagePort port = entry.getValue();
                BlockPos pos = entry.getKey();
                PostboxBlockEntity box = null;
                ItemInventory postboxInventory = port.offlineBuffer;
                if (level != null && level.isLoaded(pos) && (blockEntity = level.getBlockEntity(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)blockEntity;
                    postboxInventory = ppbe.inventory;
                    box = ppbe;
                }
                int size = postboxInventory.getContainerSize();
                for (int slot = 0; slot < size; ++slot) {
                    int insert;
                    ItemStack stack = postboxInventory.getItem(slot);
                    if (PackageItem.matchAddress(stack, port.address) || (insert = carriageInventory.insert(stack)) == 0) continue;
                    int count = stack.getCount();
                    if (insert == count) {
                        postboxInventory.setItem(slot, ItemStack.EMPTY);
                    } else {
                        stack.setCount(count - insert);
                    }
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                }
            }
            Iterator iterator = carriageInventory.iterator();
            block3: while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!PackageItem.isPackage(stack)) continue;
                for (Map.Entry<BlockPos, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                    BlockEntity insert;
                    GlobalPackagePort port = entry.getValue();
                    BlockPos pos = entry.getKey();
                    PostboxBlockEntity box = null;
                    if (!PackageItem.matchAddress(stack, port.address)) continue;
                    ItemInventory postboxInventory = port.offlineBuffer;
                    if (level != null && level.isLoaded(pos) && (insert = level.getBlockEntity(pos)) instanceof PostboxBlockEntity) {
                        PostboxBlockEntity ppbe = (PostboxBlockEntity)insert;
                        postboxInventory = ppbe.inventory;
                        box = ppbe;
                        box.inventory.sendMode();
                    }
                    int insert2 = postboxInventory.insert(stack);
                    if (box != null) {
                        box.inventory.receiveMode();
                    }
                    if (insert2 == 0) continue;
                    int extract = carriageInventory.extract(stack, insert2);
                    if (extract != insert2) {
                        postboxInventory.extract(stack, insert2 - extract);
                    }
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                    continue block3;
                }
            }
        }
    }
}

