/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.station;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllMapDecorationTypes;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.station.StationMapData;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class StationMarker {
    public static final Codec<StationMarker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("source").forGetter(StationMarker::getSource), (App)BlockPos.CODEC.fieldOf("target").forGetter(StationMarker::getTarget), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(StationMarker::getName)).apply((Applicative)instance, StationMarker::new));
    public static final Codec<List<StationMarker>> LIST_CODEC = CODEC.listOf();
    private final BlockPos source;
    private final BlockPos target;
    private final Component name;
    private final String id;

    public StationMarker(BlockPos source, BlockPos target, Component name) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.id = "create:station-" + target.getX() + "," + target.getY() + "," + target.getZ();
    }

    public static StationMarker fromWorld(BlockGetter level, BlockPos pos) {
        Optional stationOption = level.getBlockEntity(pos, AllBlockEntityTypes.TRACK_STATION);
        if (stationOption.isEmpty() || ((StationBlockEntity)stationOption.get()).getStation() == null) {
            return null;
        }
        String name = ((StationBlockEntity)stationOption.get()).getStation().name;
        return new StationMarker(pos, BlockEntityBehaviour.get((BlockEntity)stationOption.get(), TrackTargetingBehaviour.TYPE).getPositionForMapMarker(), (Component)Component.literal((String)name));
    }

    public BlockPos getSource() {
        return this.source;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public Component getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StationMarker that = (StationMarker)o;
        if (!this.target.equals((Object)that.target)) {
            return false;
        }
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.name);
    }

    public static MapDecoration createStationDecoration(byte x, byte y, Optional<Component> name) {
        return new MapDecoration(AllMapDecorationTypes.STATION_MAP_DECORATION, x, y, 0, name);
    }

    public record WrapperCodec(Codec<MapItemSavedData> codec) implements Codec<MapItemSavedData>
    {
        private static final String STATION_MARKERS_KEY = "create:stations";
        private static WrapperCodec CODEC;

        public static WrapperCodec get(Codec<MapItemSavedData> codec) {
            if (CODEC == null) {
                CODEC = new WrapperCodec(codec);
            }
            return CODEC;
        }

        public <T> DataResult<Pair<MapItemSavedData, T>> decode(DynamicOps<T> ops, T input) {
            return this.codec.decode(ops, input).map(pair -> {
                LIST_CODEC.parse(ops, ((MapLike)ops.getMap(input).getOrThrow()).get(STATION_MARKERS_KEY)).ifSuccess(list -> list.forEach(((StationMapData)pair.getFirst())::create$addStationMarker));
                return pair;
            });
        }

        public <T> DataResult<T> encode(MapItemSavedData input, DynamicOps<T> ops, T prefix) {
            return this.codec.encode((Object)input, ops, prefix).flatMap(result -> {
                RecordBuilder map = ops.mapBuilder();
                map.add(STATION_MARKERS_KEY, ((StationMapData)input).create$getStationMarkers().values().stream().toList(), LIST_CODEC);
                return map.build(result);
            });
        }
    }
}

