/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.train.PortalTrackProvider;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AABB;

public class AllPortalTracks {
    public static void tryRegisterIntegration(Identifier id, PortalTrackProvider provider) {
        if (BuiltInRegistries.BLOCK.containsKey(id)) {
            Block block = (Block)BuiltInRegistries.BLOCK.getValue(id);
            PortalTrackProvider.REGISTRY.register(block, provider);
        } else {
            Create.LOGGER.warn("Portal for integration wasn't found: {}. Compat outdated?", (Object)id);
        }
    }

    private static void tryRegisterSimpleInteraction(Identifier portalBlockId, Identifier dimensionId) {
        ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)dimensionId);
        AllPortalTracks.tryRegisterSimpleInteraction(portalBlockId, (ResourceKey<Level>)levelKey);
    }

    private static void tryRegisterSimpleInteraction(Identifier portalBlockId, ResourceKey<Level> levelKey) {
        AllPortalTracks.tryRegisterSimpleInteraction((Block)BuiltInRegistries.BLOCK.getValue(portalBlockId), levelKey);
    }

    private static void tryRegisterSimpleInteraction(Block portalBlock, ResourceKey<Level> levelKey) {
        PortalTrackProvider p = (level, face) -> PortalTrackProvider.fromPortal(level, face, (ResourceKey<Level>)Level.OVERWORLD, levelKey, (Portal)portalBlock);
        PortalTrackProvider.REGISTRY.register(portalBlock, p);
    }

    public static void register() {
        AllPortalTracks.tryRegisterSimpleInteraction(Blocks.NETHER_PORTAL, (ResourceKey<Level>)Level.NETHER);
    }

    public static PortalTrackProvider.Exit fromPortal(ServerLevel level, BlockFace inboundTrack, ResourceKey<Level> firstDimension, ResourceKey<Level> secondDimension, Portal portal) {
        ResourceKey<Level> resourceKey = level.dimension() == secondDimension ? firstDimension : secondDimension;
        MinecraftServer minecraftServer = level.getServer();
        ServerLevel otherLevel = minecraftServer.getLevel(resourceKey);
        if (otherLevel == null) {
            return null;
        }
        BlockPos portalPos = inboundTrack.getConnectedPos();
        BlockState portalState = level.getBlockState(portalPos);
        SuperGlueEntity probe = new SuperGlueEntity((Level)level, new AABB(portalPos));
        probe.setYRot(inboundTrack.getFace().toYRot());
        TeleportTransition dimensiontransition = portal.getPortalDestination(level, (Entity)probe, probe.blockPosition());
        if (dimensiontransition == null) {
            return null;
        }
        if (!level.isAllowedToEnterPortal((Level)dimensiontransition.newLevel())) {
            return null;
        }
        BlockPos otherPortalPos = BlockPos.containing((Position)dimensiontransition.position());
        BlockState otherPortalState = otherLevel.getBlockState(otherPortalPos);
        if (!otherPortalState.is(portalState.getBlock())) {
            return null;
        }
        Direction targetDirection = inboundTrack.getFace();
        if (targetDirection.getAxis() == otherPortalState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            targetDirection = targetDirection.getClockWise();
        }
        BlockPos otherPos = otherPortalPos.relative(targetDirection);
        return new PortalTrackProvider.Exit(otherLevel, new BlockFace(otherPos, targetDirection.getOpposite()));
    }
}

