/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.FakeTrackBlock;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntityTilt;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.IMergeableBE;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class TrackBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity,
IMergeableBE {
    Map<BlockPos, BezierConnection> connections = new HashMap<BlockPos, BezierConnection>();
    boolean cancelDrops;
    public Pair<ResourceKey<Level>, BlockPos> boundLocation;
    public TrackBlockEntityTilt tilt;

    public TrackBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.TRACK, pos, state);
        this.setLazyTickRate(100);
        this.tilt = new TrackBlockEntityTilt(this);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        this.cancelDrops |= this.level.getBlockState(pos).is((Block)AllBlocks.TRACK);
        this.removeInboundConnections(true);
    }

    public Map<BlockPos, BezierConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.level.isClientSide() && this.hasInteractableConnections()) {
            AllClientHandle.INSTANCE.registerToCurveInteraction(this);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.tilt.undoSmoothing();
    }

    @Override
    public void lazyTick() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void validateConnections() {
        HashSet<BlockPos> invalid = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            TrackBlockEntity trackBE;
            BezierConnection bc;
            block10: {
                BlockPos key;
                block9: {
                    BlockEntity blockEntity;
                    key = entry.getKey();
                    if (!key.equals((Object)(bc = entry.getValue()).getKey()) || !this.worldPosition.equals(bc.bePositions.getFirst())) {
                        invalid.add(key);
                        continue;
                    }
                    BlockState blockState = this.level.getBlockState(key);
                    Block block = blockState.getBlock();
                    if (block instanceof ITrackBlock) {
                        ITrackBlock trackBlock = (ITrackBlock)block;
                        if (!((Boolean)blockState.getValue((Property)TrackBlock.HAS_BE)).booleanValue()) {
                            for (Vec3 v : trackBlock.getTrackAxes((BlockGetter)this.level, key, blockState)) {
                                Vec3 bcEndAxis;
                                if (!(v.distanceTo(bcEndAxis = (Vec3)bc.axes.getSecond()) < 9.765625E-4) && !(v.distanceTo(bcEndAxis.scale(-1.0)) < 9.765625E-4)) continue;
                                this.level.setBlock(key, (BlockState)blockState.setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
                            }
                        }
                    }
                    if (!((blockEntity = this.level.getBlockEntity(key)) instanceof TrackBlockEntity)) break block9;
                    trackBE = (TrackBlockEntity)blockEntity;
                    if (!blockEntity.isRemoved()) break block10;
                }
                invalid.add(key);
                continue;
            }
            if (trackBE.connections.containsKey(this.worldPosition)) continue;
            trackBE.addConnection(bc.secondary());
            trackBE.tilt.tryApplySmoothing();
        }
        for (BlockPos blockPos : invalid) {
            this.removeConnection(blockPos);
        }
    }

    public void addConnection(BezierConnection connection) {
        if (this.connections.containsKey(connection.getKey()) && connection.equalsSansMaterial(this.connections.get(connection.getKey()))) {
            return;
        }
        this.connections.put(connection.getKey(), connection);
        this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 1);
        this.notifyUpdate();
        if (connection.isPrimary()) {
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void removeConnection(BlockPos target) {
        Level level;
        if (this.isTilted()) {
            this.tilt.captureSmoothingHandles();
        }
        BezierConnection removed = this.connections.remove(target);
        this.notifyUpdate();
        if (removed != null) {
            this.manageFakeTracksAlong(removed, true);
        }
        if (!this.connections.isEmpty() || ((TrackShape)((Object)this.getBlockState().getValueOrElse(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.NONE)))).isPortal()) {
            return;
        }
        BlockState blockState = this.level.getBlockState(this.worldPosition);
        if (blockState.hasProperty((Property)TrackBlock.HAS_BE)) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false)));
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RemoveBlockEntityPacket packet = new RemoveBlockEntityPacket(this.worldPosition);
            for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false)) {
                player.connection.send((Packet)packet);
            }
        }
    }

    public void removeInboundConnections(boolean dropAndDiscard) {
        BezierConnection bezierConnection2;
        for (BezierConnection bezierConnection2 : this.connections.values()) {
            BlockEntity blockEntity = this.level.getBlockEntity(bezierConnection2.getKey());
            if (!(blockEntity instanceof TrackBlockEntity)) {
                return;
            }
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            tbe.removeConnection((BlockPos)bezierConnection2.bePositions.getFirst());
            if (!dropAndDiscard) continue;
            if (!this.cancelDrops) {
                bezierConnection2.spawnItems(this.level);
            }
            bezierConnection2.spawnDestroyParticles(this.level);
        }
        if (dropAndDiscard && (bezierConnection2 = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)bezierConnection2;
            RemoveBlockEntityPacket packet = new RemoveBlockEntityPacket(this.worldPosition);
            for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false)) {
                player.connection.send((Packet)packet);
            }
        }
    }

    public void bind(ResourceKey<Level> boundDimension, BlockPos boundLocation) {
        this.boundLocation = Pair.of(boundDimension, boundLocation);
        this.setChanged();
    }

    public boolean isTilted() {
        return this.tilt.smoothingAngle.isPresent();
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        this.writeTurns(view, true);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.writeTurns(view, false);
        this.tilt.smoothingAngle.ifPresent(angle -> view.store("Smoothing", (Codec)Codec.DOUBLE, angle));
        if (this.boundLocation == null) {
            return;
        }
        view.store("BoundLocation", BlockPos.CODEC, (Object)this.boundLocation.getSecond());
        view.store("BoundDimension", Level.RESOURCE_KEY_CODEC, this.boundLocation.getFirst());
    }

    private void writeTurns(ValueOutput view, boolean restored) {
        ValueOutput.ValueOutputList list = view.childrenList("Connections");
        for (BezierConnection bezierConnection : this.connections.values()) {
            (restored ? this.tilt.restoreToOriginalCurve(bezierConnection.clone()) : bezierConnection).write(list.addChild(), this.worldPosition);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.connections.clear();
        view.childrenListOrEmpty("Connections").forEach(item -> {
            BezierConnection connection = new BezierConnection((ValueInput)item, this.worldPosition);
            this.connections.put(connection.getKey(), connection);
        });
        boolean smoothingPreviously = this.tilt.smoothingAngle.isPresent();
        this.tilt.smoothingAngle = view.read("Smoothing", (Codec)Codec.DOUBLE);
        if (smoothingPreviously != this.tilt.smoothingAngle.isPresent() && clientPacket) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 16);
        }
        if (this.level != null && this.level.isClientSide()) {
            AllClientHandle.INSTANCE.queueUpdate(this);
            if (this.hasInteractableConnections()) {
                AllClientHandle.INSTANCE.registerToCurveInteraction(this);
            } else {
                AllClientHandle.INSTANCE.removeFromCurveInteraction(this);
            }
        }
        view.read("BoundLocation", BlockPos.CODEC).ifPresent(pos -> {
            this.boundLocation = Pair.of((ResourceKey)view.read("BoundDimension", Level.RESOURCE_KEY_CODEC).orElseThrow(), pos);
        });
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void accept(BlockEntity other) {
        if (other instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)other;
            this.connections.putAll(track.connections);
        }
        this.validateConnections();
        this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 1);
    }

    public boolean hasInteractableConnections() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        HashMap<BlockPos, BezierConnection> restoredConnections = new HashMap<BlockPos, BezierConnection>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            restoredConnections.put(entry.getKey(), this.tilt.restoreToOriginalCurve(this.tilt.restoreToOriginalCurve(entry.getValue().secondary()).secondary()));
        }
        this.connections = restoredConnections;
        this.tilt.smoothingAngle = Optional.empty();
        if (transform.rotationAxis != Direction.Axis.Y) {
            return;
        }
        HashMap<BlockPos, BezierConnection> transformedConnections = new HashMap<BlockPos, BezierConnection>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            BezierConnection newConnection = entry.getValue();
            newConnection.normals.replace(transform::applyWithoutOffsetUncentered);
            newConnection.axes.replace(transform::applyWithoutOffsetUncentered);
            BlockPos diff = ((BlockPos)newConnection.bePositions.getSecond()).subtract((Vec3i)newConnection.bePositions.getFirst());
            newConnection.bePositions.setSecond(BlockPos.containing((Position)Vec3.atCenterOf((Vec3i)((Vec3i)newConnection.bePositions.getFirst())).add(transform.applyWithoutOffsetUncentered(Vec3.atLowerCornerOf((Vec3i)diff)))));
            Vec3 beVec = Vec3.atLowerCornerOf((Vec3i)this.worldPosition);
            Vec3 teCenterVec = beVec.add(0.5, 0.5, 0.5);
            Vec3 start = (Vec3)newConnection.starts.getFirst();
            Vec3 startToBE = start.subtract(teCenterVec);
            Vec3 endToStart = ((Vec3)newConnection.starts.getSecond()).subtract(start);
            startToBE = transform.applyWithoutOffsetUncentered(startToBE).add(teCenterVec);
            endToStart = transform.applyWithoutOffsetUncentered(endToStart).add(startToBE);
            newConnection.starts.setFirst(new TrackNodeLocation(startToBE).getLocation());
            newConnection.starts.setSecond(new TrackNodeLocation(endToStart).getLocation());
            BlockPos newTarget = newConnection.getKey();
            transformedConnections.put(newTarget, newConnection);
        }
        this.connections = transformedConnections;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.level.isClientSide()) {
            AllClientHandle.INSTANCE.removeFromCurveInteraction(this);
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (BezierConnection connection : this.connections.values()) {
            this.manageFakeTracksAlong(connection, true);
        }
        if (this.boundLocation != null && this.level instanceof ServerLevel) {
            ServerLevel otherLevel = this.level.getServer().getLevel(this.boundLocation.getFirst());
            if (otherLevel == null) {
                return;
            }
            if (otherLevel.getBlockState(this.boundLocation.getSecond()).is(AllBlockTags.TRACKS)) {
                otherLevel.destroyBlock(this.boundLocation.getSecond(), false);
            }
        }
    }

    public void manageFakeTracksAlong(BezierConnection bc, boolean remove) {
        Map<Pair<Integer, Integer>, Double> yLevels = bc.rasterise();
        for (Map.Entry<Pair<Integer, Integer>, Double> entry : yLevels.entrySet()) {
            double yValue = entry.getValue();
            int floor = Mth.floor((double)yValue);
            BlockPos targetPos = new BlockPos(entry.getKey().getFirst().intValue(), floor, entry.getKey().getSecond().intValue());
            targetPos = targetPos.offset((Vec3i)bc.bePositions.getFirst()).above(1);
            BlockState stateAtPos = this.level.getBlockState(targetPos);
            boolean present = stateAtPos.is((Block)AllBlocks.FAKE_TRACK);
            if (remove) {
                if (!present) continue;
                this.level.removeBlock(targetPos, false);
                continue;
            }
            FluidState fluidState = stateAtPos.getFluidState();
            if (!fluidState.isEmpty() && !fluidState.isSourceOfType((Fluid)Fluids.WATER)) continue;
            if (!present && stateAtPos.canBeReplaced()) {
                this.level.setBlock(targetPos, ProperWaterloggedBlock.withWater((LevelReader)this.level, AllBlocks.FAKE_TRACK.defaultBlockState(), targetPos), 3);
            }
            FakeTrackBlock.keepAlive((LevelAccessor)this.level, targetPos);
        }
    }
}

