/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackPlacement;
import com.zurrtum.create.infrastructure.component.ConnectingFrom;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TrackBlockItem
extends BlockItem {
    public TrackBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResult use(Level world, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown() && this.isFoil(stack)) {
            return TrackBlockItem.clearSelection(stack, world, player);
        }
        return super.use(world, player, usedHand);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        SoundType soundtype;
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = pContext.getPlayer();
        if (player == null) {
            return super.useOn(pContext);
        }
        if (pContext.getHand() == InteractionHand.OFF_HAND) {
            return super.useOn(pContext);
        }
        Vec3 lookAngle = player.getLookAngle();
        if (!this.isFoil(stack)) {
            TrackBlockEntity tbe;
            TrackBlock track;
            Block block = state.getBlock();
            if (block instanceof TrackBlock && (track = (TrackBlock)block).getTrackAxes((BlockGetter)level, pos, state).size() > 1) {
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"create.track.junction_start").withStyle(ChatFormatting.RED), true);
                }
                return InteractionResult.SUCCESS;
            }
            block = level.getBlockEntity(pos);
            if (block instanceof TrackBlockEntity && (tbe = (TrackBlockEntity)block).isTilted()) {
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"create.track.turn_start").withStyle(ChatFormatting.RED), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (TrackBlockItem.select((LevelAccessor)level, pos, lookAngle, stack)) {
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.75f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return super.useOn(pContext);
        }
        if (player.isShiftKeyDown()) {
            return TrackBlockItem.clearSelection(stack, level, player);
        }
        boolean placing = !(state.getBlock() instanceof ITrackBlock);
        boolean extend = (Boolean)stack.getOrDefault(AllDataComponents.TRACK_EXTENDED_CURVE, (Object)false);
        stack.remove(AllDataComponents.TRACK_EXTENDED_CURVE);
        if (placing) {
            if (!state.canBeReplaced()) {
                pos = pos.relative(pContext.getClickedFace());
            }
            if ((state = this.getPlacementState(pContext)) == null) {
                return InteractionResult.FAIL;
            }
        }
        ItemStack offhandItem = player.getOffhandItem();
        boolean hasGirder = offhandItem.is((Item)AllItems.METAL_GIRDER);
        TrackPlacement.PlacementInfo info = TrackPlacement.tryConnect(level, player, pos, state, stack, hasGirder, extend);
        if (info.message != null && !level.isClientSide()) {
            player.displayClientMessage((Component)Component.translatable((String)("create." + info.message)), true);
        }
        if (!info.valid) {
            AllSoundEvents.DENY.playFrom((Entity)player, 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        stack = player.getMainHandItem();
        if (stack.is(AllItemTags.TRACKS)) {
            stack.remove(AllDataComponents.TRACK_CONNECTING_FROM);
            stack.remove(AllDataComponents.TRACK_EXTENDED_CURVE);
            player.setItemInHand(pContext.getHand(), stack);
        }
        if ((soundtype = state.getSoundType()) != null) {
            level.playSound(null, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult clearSelection(ItemStack stack, Level level, Player player) {
        if (level.isClientSide()) {
            level.playSound((Entity)player, player.blockPosition(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.75f, 1.0f);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"create.track.selection_cleared"), true);
            stack.remove(AllDataComponents.TRACK_CONNECTING_FROM);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
    }

    public BlockState getPlacementState(UseOnContext pContext) {
        return this.getPlacementState(this.updatePlacementContext(new BlockPlaceContext(pContext)));
    }

    public static boolean select(LevelAccessor world, BlockPos pos, Vec3 lookVec, ItemStack heldItem) {
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock track = (ITrackBlock)block;
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis = track.getNearestTrackAxis((BlockGetter)world, pos, blockState, lookVec);
        Vec3 axis = nearestTrackAxis.getFirst().scale(nearestTrackAxis.getSecond() == Direction.AxisDirection.POSITIVE ? -1.0 : 1.0);
        Vec3 end = track.getCurveStart((BlockGetter)world, pos, blockState, axis);
        Vec3 normal = track.getUpNormal((BlockGetter)world, pos, blockState).normalize();
        heldItem.set(AllDataComponents.TRACK_CONNECTING_FROM, (Object)new ConnectingFrom(pos, axis, normal, end));
        return true;
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(AllDataComponents.TRACK_CONNECTING_FROM);
    }
}

