/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.content.trains.track.TrackPaver;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.ConnectingFrom;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrackPlacement {
    public static PlacementInfo cached;
    public static BlockPos hoveringPos;
    public static boolean hoveringMaxed;
    static int hoveringAngle;
    static ItemStack lastItem;

    public static PlacementInfo tryConnect(Level level, Player player, BlockPos pos2, BlockState state2, ItemStack stack, boolean girder, boolean maximiseTurn) {
        boolean shouldPave;
        double[] sTest;
        boolean slope;
        double[] intersect;
        TrackBlockEntity tbe;
        ITrackBlock track;
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis;
        Vec3 lookVec = player.getLookAngle();
        int lookAngle = (int)(22.5 + (double)(AngleHelper.deg(Mth.atan2((double)lookVec.z, (double)lookVec.x)) % 360.0f)) / 8;
        int maxLength = (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get();
        if (level.isClientSide() && cached != null && pos2.equals((Object)hoveringPos) && stack.equals(lastItem) && hoveringMaxed == maximiseTurn && lookAngle == hoveringAngle) {
            return cached;
        }
        PlacementInfo info = new PlacementInfo(TrackMaterial.fromItem(stack.getItem()));
        hoveringMaxed = maximiseTurn;
        hoveringAngle = lookAngle;
        hoveringPos = pos2;
        lastItem = stack;
        cached = info;
        Vec3 axis2 = nearestTrackAxis.getFirst().scale((nearestTrackAxis = (track = (ITrackBlock)state2.getBlock()).getNearestTrackAxis((BlockGetter)level, pos2, state2, lookVec)).getSecond() == Direction.AxisDirection.POSITIVE ? -1.0 : 1.0);
        Vec3 normal2 = track.getUpNormal((BlockGetter)level, pos2, state2).normalize();
        Vec3 normedAxis2 = axis2.normalize();
        Vec3 end2 = track.getCurveStart((BlockGetter)level, pos2, state2, axis2);
        ConnectingFrom connectingFrom = (ConnectingFrom)stack.get(AllDataComponents.TRACK_CONNECTING_FROM);
        BlockPos pos1 = connectingFrom.pos();
        Vec3 axis1 = connectingFrom.axis();
        Vec3 normedAxis1 = axis1.normalize();
        Vec3 end1 = connectingFrom.end();
        Vec3 normal1 = connectingFrom.normal();
        BlockState state1 = level.getBlockState(pos1);
        if (level.isClientSide()) {
            info.end1 = end1;
            info.end2 = end2;
            info.normal1 = normal1;
            info.normal2 = normal2;
            info.axis1 = axis1;
            info.axis2 = axis2;
        }
        if (pos1.equals((Object)pos2)) {
            return info.withMessage("second_point");
        }
        if (pos1.distSqr((Vec3i)pos2) > (double)(maxLength * maxLength)) {
            return info.withMessage("too_far").tooJumbly();
        }
        if (!state1.hasProperty((Property)TrackBlock.HAS_BE)) {
            return info.withMessage("original_missing");
        }
        BlockEntity blockEntity = level.getBlockEntity(pos2);
        if (blockEntity instanceof TrackBlockEntity && (tbe = (TrackBlockEntity)blockEntity).isTilted()) {
            return info.withMessage("turn_start");
        }
        if (axis1.dot(end2.subtract(end1)) < 0.0) {
            axis1 = axis1.scale(-1.0);
            normedAxis1 = normedAxis1.scale(-1.0);
            end1 = track.getCurveStart((BlockGetter)level, pos1, state1, axis1);
            if (level.isClientSide()) {
                info.end1 = end1;
                info.axis1 = axis1;
            }
        }
        boolean parallel = (intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, Direction.Axis.Y)) == null;
        boolean skipCurve = false;
        if (parallel && normedAxis1.dot(normedAxis2) > 0.0 || !parallel && (intersect[0] < 0.0 || intersect[1] < 0.0)) {
            axis2 = axis2.scale(-1.0);
            normedAxis2 = normedAxis2.scale(-1.0);
            end2 = track.getCurveStart((BlockGetter)level, pos2, state2, axis2);
            if (level.isClientSide()) {
                info.end2 = end2;
                info.axis2 = axis2;
            }
        }
        Vec3 cross2 = normedAxis2.cross(new Vec3(0.0, 1.0, 0.0));
        double a1 = Mth.atan2((double)normedAxis2.z, (double)normedAxis2.x);
        double a2 = Mth.atan2((double)normedAxis1.z, (double)normedAxis1.x);
        double angle = a1 - a2;
        double ascend = end2.subtract((Vec3)end1).y;
        double absAscend = Math.abs(ascend);
        boolean bl = slope = !normal1.equals((Object)normal2);
        if (level.isClientSide()) {
            Vec3 offset1 = axis1.scale((double)info.end1Extent);
            Vec3 offset2 = axis2.scale((double)info.end2Extent);
            BlockPos targetPos1 = pos1.offset((Vec3i)BlockPos.containing((Position)offset1));
            BlockPos targetPos2 = pos2.offset((Vec3i)BlockPos.containing((Position)offset2));
            info.curve = new BezierConnection(Couple.create(targetPos1, targetPos2), Couple.create(end1.add(offset1), end2.add(offset2)), Couple.create(normedAxis1, normedAxis2), Couple.create(normal1, normal2), true, girder, TrackMaterial.fromItem(stack.getItem()));
        }
        double dist = 0.0;
        if (parallel && (sTest = VecHelper.intersect(end1, end2, normedAxis1, cross2, Direction.Axis.Y)) != null) {
            double t = Math.abs(sTest[0]);
            double u = Math.abs(sTest[1]);
            skipCurve = Mth.equal((double)u, (double)0.0);
            if (!skipCurve && sTest[0] < 0.0) {
                return info.withMessage("perpendicular").tooJumbly();
            }
            if (skipCurve) {
                dist = VecHelper.getCenterOf((Vec3i)pos1).distanceTo(VecHelper.getCenterOf((Vec3i)pos2));
                info.end1Extent = (int)Math.round((dist + 1.0) / axis1.length());
            } else {
                double targetT;
                if (!Mth.equal((double)ascend, (double)0.0) || normedAxis1.y != 0.0) {
                    return info.withMessage("ascending_s_curve");
                }
                double d = targetT = u <= 1.0 ? 3.0 : u * 2.0;
                if (t < targetT) {
                    return info.withMessage("too_sharp");
                }
                if (t > targetT) {
                    int correction = (int)((t - targetT) / axis1.length());
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + correction % 2;
                    int n = info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }
            }
        }
        if (slope) {
            double dist2;
            if (!skipCurve) {
                return info.withMessage("slope_turn");
            }
            if (Mth.equal((double)normal1.dot(normal2), (double)0.0)) {
                return info.withMessage("opposing_slopes");
            }
            if ((axis1.y < 0.0 || axis2.y > 0.0) && ascend > 0.0) {
                return info.withMessage("leave_slope_ascending");
            }
            if ((axis1.y > 0.0 || axis2.y < 0.0) && ascend < 0.0) {
                return info.withMessage("leave_slope_descending");
            }
            skipCurve = false;
            info.end1Extent = 0;
            info.end2Extent = 0;
            Direction.Axis plane = Mth.equal((double)axis1.x, (double)0.0) ? Direction.Axis.X : Direction.Axis.Z;
            intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, plane);
            double dist1 = Math.abs(intersect[0] / axis1.length());
            if (dist1 > (dist2 = Math.abs(intersect[1] / axis2.length()))) {
                info.end1Extent = (int)Math.round(dist1 - dist2);
            }
            if (dist2 > dist1) {
                info.end2Extent = (int)Math.round(dist2 - dist1);
            }
            double turnSize = Math.min(dist1, dist2);
            if (intersect[0] < 0.0 || intersect[1] < 0.0) {
                return info.withMessage("too_sharp").tooJumbly();
            }
            if (turnSize < 2.0) {
                return info.withMessage("too_sharp");
            }
            if (turnSize > 2.0 && !maximiseTurn) {
                info.end1Extent = (int)((double)info.end1Extent + (turnSize - 2.0));
                info.end2Extent = (int)((double)info.end2Extent + (turnSize - 2.0));
                turnSize = 2.0;
            }
        }
        if (skipCurve && !Mth.equal((double)ascend, (double)0.0)) {
            int hDistance = info.end1Extent;
            if (axis1.y == 0.0 || !Mth.equal((double)(absAscend + 1.0), (double)(dist / axis1.length()))) {
                if (axis1.y != 0.0 && axis1.y == -axis2.y) {
                    return info.withMessage("ascending_s_curve");
                }
                info.end1Extent = 0;
                double minHDistance = Math.max(absAscend < 4.0 ? absAscend * 4.0 : absAscend * 3.0, 6.0) / axis1.length();
                if ((double)hDistance < minHDistance) {
                    return info.withMessage("too_steep");
                }
                if ((double)hDistance > minHDistance) {
                    int correction = (int)((double)hDistance - minHDistance);
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + correction % 2;
                    info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }
                skipCurve = false;
            }
        }
        if (!parallel) {
            boolean ninety;
            float absAngle = Math.abs(AngleHelper.deg(angle));
            if (absAngle < 60.0f || absAngle > 300.0f) {
                return info.withMessage("turn_90").tooJumbly();
            }
            intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, Direction.Axis.Y);
            double dist1 = Math.abs(intersect[0]);
            double dist2 = Math.abs(intersect[1]);
            float ex1 = 0.0f;
            float ex2 = 0.0f;
            if (dist1 > dist2) {
                ex1 = (float)((dist1 - dist2) / axis1.length());
            }
            if (dist2 > dist1) {
                ex2 = (float)((dist2 - dist1) / axis2.length());
            }
            double turnSize = Math.min(dist1, dist2) - 0.1;
            boolean bl2 = ninety = (absAngle + 0.25f) % 90.0f < 1.0f;
            if (intersect[0] < 0.0 || intersect[1] < 0.0) {
                return info.withMessage("too_sharp").tooJumbly();
            }
            double minTurnSize = ninety ? 7.0 : 3.25;
            double turnSizeToFitAscend = minTurnSize + (ninety ? Math.max(0.0, absAscend - 3.0) * 2.0 : Math.max(0.0, absAscend - 1.5) * 1.5);
            if (turnSize < minTurnSize) {
                return info.withMessage("too_sharp");
            }
            if (turnSize < turnSizeToFitAscend) {
                return info.withMessage("too_steep");
            }
            if (!maximiseTurn) {
                ex1 = (float)((double)ex1 + (turnSize - turnSizeToFitAscend) / axis1.length());
                ex2 = (float)((double)ex2 + (turnSize - turnSizeToFitAscend) / axis2.length());
            }
            info.end1Extent = Mth.floor((float)ex1);
            info.end2Extent = Mth.floor((float)ex2);
            turnSize = turnSizeToFitAscend;
        }
        Vec3 offset1 = axis1.scale((double)info.end1Extent);
        Vec3 offset2 = axis2.scale((double)info.end2Extent);
        BlockPos targetPos1 = pos1.offset((Vec3i)BlockPos.containing((Position)offset1));
        BlockPos targetPos2 = pos2.offset((Vec3i)BlockPos.containing((Position)offset2));
        info.curve = skipCurve ? null : new BezierConnection(Couple.create(targetPos1, targetPos2), Couple.create(end1.add(offset1), end2.add(offset2)), Couple.create(normedAxis1, normedAxis2), Couple.create(normal1, normal2), true, girder, TrackMaterial.fromItem(stack.getItem()));
        info.valid = true;
        info.pos1 = pos1;
        info.pos2 = pos2;
        info.axis1 = axis1;
        info.axis2 = axis2;
        TrackPlacement.placeTracks(level, info, state1, state2, targetPos1, targetPos2, true);
        ItemStack offhandItem = player.getOffhandItem().copy();
        boolean bl3 = shouldPave = offhandItem.getItem() instanceof BlockItem && !offhandItem.is(AllItemTags.INVALID_FOR_TRACK_PAVING);
        if (shouldPave) {
            BlockItem paveItem = (BlockItem)offhandItem.getItem();
            TrackPlacement.paveTracks(level, info, paveItem, true);
            info.hasRequiredPavement = true;
        }
        info.hasRequiredTracks = true;
        if (!player.isCreative()) {
            for (boolean simulate : Iterate.trueAndFalse) {
                if (level.isClientSide() && !simulate) break;
                int tracks = info.requiredTracks;
                int pavement = info.requiredPavement;
                int foundTracks = 0;
                int foundPavement = 0;
                Inventory inv = player.getInventory();
                NonNullList main = inv.getNonEquipmentItems();
                int end = 37;
                for (int j = 0; j <= end; ++j) {
                    boolean isTrack;
                    boolean offhand;
                    int i = j;
                    boolean bl4 = offhand = j == end;
                    if (j == 36) {
                        i = inv.getSelectedSlot();
                    } else if (offhand) {
                        i = 0;
                    } else if (j == inv.getSelectedSlot()) continue;
                    ItemStack stackInSlot = offhand ? inv.getItem(40) : (ItemStack)main.get(i);
                    boolean bl5 = isTrack = stackInSlot.is(AllItemTags.TRACKS) && stackInSlot.is(stack.getItem());
                    if (!isTrack && (!shouldPave || offhandItem.getItem() != stackInSlot.getItem()) || (isTrack ? foundTracks >= tracks : foundPavement >= pavement)) continue;
                    int count = stackInSlot.getCount();
                    if (!simulate) {
                        int remainingItems = count - Math.min(isTrack ? tracks - foundTracks : pavement - foundPavement, count);
                        if (i == inv.getSelectedSlot()) {
                            stackInSlot.remove(AllDataComponents.TRACK_CONNECTING_FROM);
                        }
                        ItemStack newItem = stackInSlot.copyWithCount(remainingItems);
                        if (offhand) {
                            player.setItemInHand(InteractionHand.OFF_HAND, newItem);
                        } else {
                            inv.setItem(i, newItem);
                        }
                    }
                    if (isTrack) {
                        foundTracks += count;
                        continue;
                    }
                    foundPavement += count;
                }
                if (!simulate) continue;
                if (foundTracks < tracks) {
                    info.valid = false;
                    info.tooJumbly();
                    info.hasRequiredTracks = false;
                    return info.withMessage("not_enough_tracks");
                }
                if (foundPavement >= pavement) continue;
                info.valid = false;
                info.tooJumbly();
                info.hasRequiredPavement = false;
                return info.withMessage("not_enough_pavement");
            }
        }
        if (level.isClientSide()) {
            return info;
        }
        if (shouldPave) {
            BlockItem paveItem = (BlockItem)offhandItem.getItem();
            TrackPlacement.paveTracks(level, info, paveItem, false);
        }
        return TrackPlacement.placeTracks(level, info, state1, state2, targetPos1, targetPos2, false);
    }

    private static void paveTracks(Level level, PlacementInfo info, BlockItem blockItem, boolean simulate) {
        Block block = blockItem.getBlock();
        info.requiredPavement = 0;
        if (block == null || block instanceof EntityBlock || block.defaultBlockState().getCollisionShape((BlockGetter)level, info.pos1).isEmpty()) {
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (boolean first : Iterate.trueAndFalse) {
            int extent = (first ? info.end1Extent : info.end2Extent) + (info.curve != null ? 1 : 0);
            Vec3 axis = first ? info.axis1 : info.axis2;
            BlockPos pavePos = first ? info.pos1 : info.pos2;
            info.requiredPavement += TrackPaver.paveStraight(level, pavePos.below(), axis, extent, block, simulate, visited);
        }
        if (info.curve != null) {
            info.requiredPavement += TrackPaver.paveCurve(level, info.curve, block, simulate, visited);
        }
    }

    private static PlacementInfo placeTracks(Level level, PlacementInfo info, BlockState state1, BlockState state2, BlockPos targetPos1, BlockPos targetPos2, boolean simulate) {
        TrackBlockEntity tte1;
        int requiredTracksForTurn;
        BlockEntity te2;
        block17: {
            block16: {
                info.requiredTracks = 0;
                for (boolean first : Iterate.trueAndFalse) {
                    BlockState state;
                    int extent = first ? info.end1Extent : info.end2Extent;
                    Vec3 axis = first ? info.axis1 : info.axis2;
                    BlockPos pos = first ? info.pos1 : info.pos2;
                    BlockState blockState = state = first ? state1 : state2;
                    if (state.hasProperty((Property)TrackBlock.HAS_BE) && !simulate) {
                        state = (BlockState)state.setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false));
                    }
                    switch ((TrackShape)((Object)state.getValue(TrackBlock.SHAPE))) {
                        case TE: 
                        case TW: {
                            state = (BlockState)state.setValue(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.XO));
                            break;
                        }
                        case TN: 
                        case TS: {
                            state = (BlockState)state.setValue(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.ZO));
                            break;
                        }
                    }
                    for (int i = 0; i < (info.curve != null ? extent + 1 : extent); ++i) {
                        boolean canPlace;
                        Vec3 offset = axis.scale((double)i);
                        BlockPos offsetPos = pos.offset((Vec3i)BlockPos.containing((Position)offset));
                        BlockState stateAtPos = level.getBlockState(offsetPos);
                        BlockState toPlace = BlockHelper.copyProperties(state, info.trackMaterial.getBlock().defaultBlockState());
                        boolean bl = canPlace = stateAtPos.canBeReplaced() || stateAtPos.is(BlockTags.FLOWERS);
                        if (canPlace) {
                            ++info.requiredTracks;
                        }
                        if (simulate) continue;
                        Block block = stateAtPos.getBlock();
                        if (block instanceof ITrackBlock) {
                            ITrackBlock trackAtPos = (ITrackBlock)block;
                            toPlace = trackAtPos.overlay((BlockGetter)level, offsetPos, stateAtPos, toPlace);
                            canPlace = true;
                        }
                        if (!canPlace) continue;
                        level.setBlock(offsetPos, ProperWaterloggedBlock.withWater((LevelReader)level, toPlace, offsetPos), 3);
                    }
                }
                if (info.curve == null) {
                    return info;
                }
                if (!simulate) {
                    BlockState onto = info.trackMaterial.getBlock().defaultBlockState();
                    BlockState stateAtPos = level.getBlockState(targetPos1);
                    level.setBlock(targetPos1, ProperWaterloggedBlock.withWater((LevelReader)level, (BlockState)(stateAtPos.is(AllBlockTags.TRACKS) ? stateAtPos : BlockHelper.copyProperties(state1, onto)).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), targetPos1), 3);
                    stateAtPos = level.getBlockState(targetPos2);
                    level.setBlock(targetPos2, ProperWaterloggedBlock.withWater((LevelReader)level, (BlockState)(stateAtPos.is(AllBlockTags.TRACKS) ? stateAtPos : BlockHelper.copyProperties(state2, onto)).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), targetPos2), 3);
                }
                BlockEntity te1 = level.getBlockEntity(targetPos1);
                te2 = level.getBlockEntity(targetPos2);
                requiredTracksForTurn = (info.curve.getSegmentCount() + 1) / 2;
                if (!(te1 instanceof TrackBlockEntity)) break block16;
                tte1 = (TrackBlockEntity)te1;
                if (te2 instanceof TrackBlockEntity) break block17;
            }
            info.requiredTracks += requiredTracksForTurn;
            return info;
        }
        TrackBlockEntity tte2 = (TrackBlockEntity)te2;
        if (!tte1.getConnections().containsKey(tte2.getBlockPos())) {
            info.requiredTracks += requiredTracksForTurn;
        }
        if (simulate) {
            return info;
        }
        tte1.addConnection(info.curve);
        tte2.addConnection(info.curve.secondary());
        tte1.tilt.tryApplySmoothing();
        tte2.tilt.tryApplySmoothing();
        return info;
    }

    public static class PlacementInfo {
        public BezierConnection curve = null;
        public boolean valid = false;
        public int end1Extent = 0;
        public int end2Extent = 0;
        public String message = null;
        public int requiredTracks = 0;
        public boolean hasRequiredTracks = false;
        public int requiredPavement = 0;
        public boolean hasRequiredPavement = false;
        public final TrackMaterial trackMaterial;
        public Vec3 end1;
        public Vec3 end2;
        public Vec3 normal1;
        public Vec3 normal2;
        public Vec3 axis1;
        public Vec3 axis2;
        BlockPos pos1;
        BlockPos pos2;

        public PlacementInfo(TrackMaterial material) {
            this.trackMaterial = material;
        }

        public PlacementInfo withMessage(String message) {
            this.message = "track." + message;
            return this;
        }

        public PlacementInfo tooJumbly() {
            this.curve = null;
            return this;
        }
    }
}

