/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraphHelper;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public class TrackTargetingBlockItem
extends BlockItem {
    private final EdgePointType<?> type;

    public TrackTargetingBlockItem(Block pBlock, Item.Properties pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties);
        this.type = type;
    }

    public static TrackTargetingBlockItem station(Block pBlock, Item.Properties pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.STATION);
    }

    public static TrackTargetingBlockItem signal(Block pBlock, Item.Properties pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.SIGNAL);
    }

    public static TrackTargetingBlockItem observer(Block pBlock, Item.Properties pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.OBSERVER);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && stack.has(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"create.track_target.clear"), true);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        Block block = state.getBlock();
        if (block instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)block;
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.getLookAngle();
            boolean front = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
            EdgePointType<?> type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackTargetingBlockItem.withGraphLocation(level, pos, front, null, type, (overlap, location) -> result.setValue((Object)overlap));
            if (((OverlapResult)((Object)result.getValue())).feedback != null) {
                player.displayClientMessage((Component)Component.translatable((String)("create." + ((OverlapResult)((Object)result.getValue())).feedback)).withStyle(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            stack.set(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS, (Object)pos);
            stack.set(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)front);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            player.displayClientMessage((Component)Component.translatable((String)"create.track_target.set"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!stack.has(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            player.displayClientMessage((Component)Component.translatable((String)"create.track_target.missing").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        CompoundTag blockEntityData = new CompoundTag();
        blockEntityData.putBoolean("TargetDirection", ((Boolean)stack.getOrDefault(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)false)).booleanValue());
        BlockPos selectedPos = (BlockPos)stack.get(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        BlockPos placedPos = pos.relative(pContext.getClickedFace(), state.canBeReplaced() ? 0 : 1);
        boolean bezier = stack.has(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        if (!selectedPos.closerThan((Vec3i)placedPos, bezier ? (double)((Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16) : 16.0)) {
            player.displayClientMessage((Component)Component.translatable((String)"create.track_target.too_far").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (bezier) {
            BezierTrackPointLocation bezierTrackPointLocation = (BezierTrackPointLocation)stack.get(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            CompoundTag bezierNbt = new CompoundTag();
            bezierNbt.putInt("Segment", bezierTrackPointLocation.segment());
            bezierNbt.store("Key", BlockPos.CODEC, (Object)bezierTrackPointLocation.curveTarget().subtract((Vec3i)placedPos));
            blockEntityData.put("Bezier", (Tag)bezierNbt);
        }
        blockEntityData.store("TargetTrack", BlockPos.CODEC, (Object)selectedPos.subtract((Vec3i)placedPos));
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)TypedEntityData.of(((IBE)this.getBlock()).getBlockEntityType(), (CompoundTag)blockEntityData));
        stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
        stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        InteractionResult useOn = super.useOn(pContext);
        stack.remove(DataComponents.BLOCK_ENTITY_DATA);
        if (level.isClientSide() || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        ItemStack itemInHand = player.getItemInHand(pContext.getHand());
        if (!itemInHand.isEmpty()) {
            itemInHand.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            itemInHand.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            itemInHand.remove(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        }
        player.displayClientMessage((Component)Component.translatable((String)"create.track_target.success").withStyle(ChatFormatting.GREEN), true);
        if (this.type == EdgePointType.SIGNAL) {
            AllAdvancements.SIGNAL.trigger((ServerPlayer)player);
        }
        return useOn;
    }

    public EdgePointType<?> getType(ItemStack stack) {
        return this.type;
    }

    public static void withGraphLocation(Level level, BlockPos pos, boolean front, BezierTrackPointLocation targetBezier, EdgePointType<?> type, BiConsumer<OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof ITrackBlock)) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        List<Vec3> trackAxes = track.getTrackAxes((BlockGetter)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(OverlapResult.JUNCTION, null);
            return;
        }
        Direction.AxisDirection targetDirection = front ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.getFirst());
        if (location == null) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        Couple<TrackNode> nodes = location.edge.map(location.graph::locateNode);
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        EdgeData edgeData = edge.getEdgeData();
        double edgePosition = location.position;
        for (TrackEdgePoint edgePoint : edgeData.getPoints()) {
            double otherEdgePosition = edgePoint.getLocationOn(edge);
            double distance = Math.abs(edgePosition - otherEdgePosition);
            if (distance > 0.75 || edgePoint.canCoexistWith(type, front) && distance < 0.25) continue;
            callback.accept(OverlapResult.OCCUPIED, location);
            return;
        }
        callback.accept(OverlapResult.VALID, location);
    }

    public static enum OverlapResult {
        VALID,
        OCCUPIED("track_target.occupied"),
        JUNCTION("track_target.no_junctions"),
        NO_TRACK("track_target.invalid");

        public String feedback;

        private OverlapResult() {
        }

        private OverlapResult(String feedback) {
            this.feedback = feedback;
        }
    }
}

