/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.advancement;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.resources.Identifier;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public class CreateTrigger
implements CriterionTrigger<Conditions> {
    public final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<Conditions>>> listeners = Maps.newHashMap();
    public final Identifier id;

    public CreateTrigger(Identifier id) {
        this.id = id;
    }

    public void addPlayerListener(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Conditions> listener) {
        this.listeners.computeIfAbsent(playerAdvancementsIn, k -> new HashSet()).add(listener);
    }

    public void removePlayerListener(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Conditions> listener) {
        Set<CriterionTrigger.Listener<Conditions>> playerListeners = this.listeners.get(playerAdvancementsIn);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void removePlayerListeners(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player) {
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        Set<CriterionTrigger.Listener<Conditions>> playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            for (CriterionTrigger.Listener<Conditions> listener : playerListeners) {
                listener.run(playerAdvancements);
            }
        }
    }

    public static class Conditions
    implements CriterionTriggerInstance {
        public static final Codec<Conditions> CODEC = MapCodec.unitCodec((Object)new Conditions());

        public void validate(CriterionValidator validator) {
        }
    }
}

