/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.api.schematic.nbt.PartialSafeNBT;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.CachedInventoryBehaviour;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.ponder.api.VirtualBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class SmartBlockEntity
extends CachedRenderBBBlockEntity
implements PartialSafeNBT,
IInteractionChecker,
SpecialBlockEntityItemRequirement,
VirtualBlockEntity {
    private final Map<BehaviourType<?>, BlockEntityBehaviour<?>> behaviours = new Reference2ObjectArrayMap();
    protected int lazyTickRate;
    protected int lazyTickCounter;
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    private boolean chunkUnloaded;
    private boolean virtualMode;

    public SmartBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        ArrayList list = new ArrayList();
        this.addBehaviours(list);
        AllTransfer.addBehaviours(this, list);
        list.forEach((Consumer<BlockEntityBehaviour<?>>)((Consumer<BlockEntityBehaviour>)b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour<?>)b)));
        list.clear();
        AllClientHandle.INSTANCE.addBehaviours(this, list);
        list.forEach((Consumer<BlockEntityBehaviour<?>>)((Consumer<BlockEntityBehaviour>)b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour<?>)b)));
    }

    public abstract void addBehaviours(List<BlockEntityBehaviour<?>> var1);

    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public void initialize() {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
        }
        this.forEachBehaviour(BlockEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void tick() {
        if (!this.initialized && this.hasLevel()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.forEachBehaviour(BlockEntityBehaviour::tick);
    }

    public void lazyTick() {
    }

    protected void write(ValueOutput view, boolean clientPacket) {
        super.saveAdditional(view);
        this.forEachBehaviour(tb -> tb.write(view, clientPacket));
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.saveAdditional(view);
        this.forEachBehaviour(tb -> {
            if (tb.isSafeNBT()) {
                tb.writeSafe(view);
            }
        });
    }

    protected void read(ValueInput view, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList list = new ArrayList();
            this.addBehavioursDeferred(list);
            list.forEach((Consumer<BlockEntityBehaviour<?>>)((Consumer<BlockEntityBehaviour>)b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour<?>)b)));
        }
        super.loadAdditional(view);
        this.forEachBehaviour(tb -> tb.read(view, clientPacket));
    }

    protected void loadAdditional(ValueInput view) {
        this.read(view, false);
    }

    public void onChunkUnloaded() {
        this.chunkUnloaded = true;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.chunkUnloaded) {
            this.remove();
        }
        this.invalidate();
    }

    public void invalidate() {
        this.forEachBehaviour(BlockEntityBehaviour::unload);
    }

    public void remove() {
    }

    public void destroy() {
        this.forEachBehaviour(BlockEntityBehaviour::destroy);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        this.destroy();
    }

    protected void saveAdditional(ValueOutput view) {
        this.write(view, false);
    }

    @Override
    public final void readClient(ValueInput view) {
        this.read(view, true);
    }

    @Override
    public final void writeClient(ValueOutput view) {
        this.write(view, true);
    }

    public <T extends BlockEntityBehaviour<?>> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    public void forEachBehaviour(Consumer<BlockEntityBehaviour<?>> action) {
        this.getAllBehaviours().forEach(action);
    }

    public Collection<BlockEntityBehaviour<?>> getAllBehaviours() {
        return this.behaviours.values();
    }

    public <T extends SmartBlockEntity> void attachBehaviourLate(BlockEntityBehaviour<T> behaviour) {
        BehaviourType<?> type = behaviour.getType();
        this.behaviours.values().forEach(b -> b.onBehaviourAdded(type, behaviour));
        this.behaviours.put(type, behaviour);
        behaviour.blockEntity = this;
        behaviour.initialize();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        return this.getAllBehaviours().stream().reduce(ItemRequirement.NONE, (r, b) -> r.union(b.getRequiredItems()), ItemRequirement::union);
    }

    public void removeBehaviour(BehaviourType<?> type) {
        BlockEntityBehaviour<?> remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.unload();
        }
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    @Override
    public void markVirtual() {
        this.virtualMode = true;
    }

    @Override
    public boolean isVirtual() {
        return this.virtualMode;
    }

    public boolean isChunkUnloaded() {
        return this.chunkUnloaded;
    }

    @Override
    public boolean canPlayerUse(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void sendToMenu(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.getBlockPos());
        buffer.writeNbt((Tag)this.getUpdateTag((HolderLookup.Provider)buffer.registryAccess()));
    }

    public void refreshBlockState() {
        this.setBlockState(this.getLevel().getBlockState(this.getBlockPos()));
    }

    public void addAdvancementBehaviour(ServerPlayer player) {
        List<CreateTrigger> awardables = this.getAwardables();
        if (awardables != null) {
            this.behaviours.put(AdvancementBehaviour.TYPE, new AdvancementBehaviour(this, player, (CreateTrigger[])awardables.toArray(CreateTrigger[]::new)));
        }
    }

    public List<CreateTrigger> getAwardables() {
        return null;
    }

    public void award(CreateTrigger advancement) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public void awardIfNear(CreateTrigger advancement, int range) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayerIfNear(advancement, range);
        }
    }

    public void resetTransferCache() {
        CachedInventoryBehaviour<?> behaviour = this.getBehaviour(CachedInventoryBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.reset();
        }
    }
}

