/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour;

import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.ConcurrentModificationException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class BlockEntityBehaviour<T extends SmartBlockEntity> {
    public T blockEntity;
    private int lazyTickRate;
    private int lazyTickCounter;

    public BlockEntityBehaviour(T be) {
        this.blockEntity = be;
        this.setLazyTickRate(10);
    }

    public static <T extends BlockEntityBehaviour<?>> T get(BlockGetter reader, BlockPos pos, BehaviourType<T> type) {
        BlockEntity be;
        try {
            be = reader.getBlockEntity(pos);
        }
        catch (ConcurrentModificationException e) {
            be = null;
        }
        return BlockEntityBehaviour.get(be, type);
    }

    public static <T extends BlockEntityBehaviour<?>> T get(BlockEntity be, BehaviourType<T> type) {
        if (be == null) {
            return null;
        }
        if (!(be instanceof SmartBlockEntity)) {
            return null;
        }
        SmartBlockEntity ste = (SmartBlockEntity)be;
        return ste.getBehaviour(type);
    }

    public abstract BehaviourType<?> getType();

    public void initialize() {
    }

    public void tick() {
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
    }

    public void read(ValueInput view, boolean clientPacket) {
    }

    public void write(ValueOutput view, boolean clientPacket) {
    }

    public void writeSafe(ValueOutput view) {
        this.write(view, false);
    }

    public boolean isSafeNBT() {
        return false;
    }

    public ItemRequirement getRequiredItems() {
        return ItemRequirement.NONE;
    }

    public void onBlockChanged(BlockState oldState) {
    }

    public void onNeighborChanged(BlockPos neighborPos) {
    }

    public void unload() {
    }

    public void destroy() {
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    public void onBehaviourAdded(BehaviourType<?> type, BlockEntityBehaviour<?> behaviour) {
    }

    public BlockPos getPos() {
        return this.blockEntity.getBlockPos();
    }

    public Level getLevel() {
        return this.blockEntity.getLevel();
    }
}

