/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.CachedInventoryBehaviour;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import org.jetbrains.annotations.Nullable;

public class CachedDirectionInventoryBehaviour<T extends SmartBlockEntity>
extends BlockEntityBehaviour<T> {
    public static final BehaviourType<CachedInventoryBehaviour<?>> TYPE = new BehaviourType();
    private final BiFunction<T, Direction, Container> factory;
    Storage<ItemVariant>[] sides = new Storage[7];

    public CachedDirectionInventoryBehaviour(T be, BiFunction<T, Direction, Container> factory) {
        super(be);
        this.factory = factory;
    }

    @Nullable
    public static <T extends SmartBlockEntity> Storage<ItemVariant> get(T be, @Nullable Direction side) {
        return ((SmartBlockEntity)be).getBehaviour(TYPE).get(side);
    }

    public Storage<ItemVariant> get(Direction side) {
        Container inventory;
        int i = side == null ? 6 : side.get3DDataValue();
        InventoryStorage sideStorage = this.sides[i];
        if (sideStorage == null && (inventory = this.factory.apply(this.blockEntity, side)) != null) {
            sideStorage = this.sides[i] = InventoryStorage.of((Container)inventory, null);
        }
        return sideStorage;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

