/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EdgeInteractionHandler {
    public static InteractionResult onBlockActivated(Level world, Player player, ItemStack heldItem, InteractionHand hand, BlockHitResult ray, BlockPos pos) {
        if (player.isShiftKeyDown()) {
            return null;
        }
        EdgeInteractionBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null) {
            return null;
        }
        if (!behaviour.requiredItem.test(heldItem.getItem())) {
            return null;
        }
        Direction activatedDirection = EdgeInteractionHandler.getActivatedDirection(world, pos, ray.getDirection(), ray.getLocation(), behaviour);
        if (activatedDirection == null) {
            return null;
        }
        if (!world.isClientSide()) {
            behaviour.connectionCallback.apply(world, pos, pos.relative(activatedDirection));
        }
        world.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
        return InteractionResult.SUCCESS;
    }

    public static List<Direction> getConnectiveSides(Level world, BlockPos pos, Direction face, EdgeInteractionBehaviour behaviour) {
        ArrayList<Direction> sides = new ArrayList<Direction>(6);
        if (BlockHelper.hasBlockSolidSide(world.getBlockState(pos.relative(face)), (BlockGetter)world, pos.relative(face), face.getOpposite())) {
            return sides;
        }
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos;
            if (direction.getAxis() == face.getAxis() || BlockHelper.hasBlockSolidSide(world.getBlockState((neighbourPos = pos.relative(direction)).relative(face)), (BlockGetter)world, neighbourPos.relative(face), face.getOpposite()) || !behaviour.connectivityPredicate.test(world, pos, face, direction)) continue;
            sides.add(direction);
        }
        return sides;
    }

    public static Direction getActivatedDirection(Level world, BlockPos pos, Direction face, Vec3 hit, EdgeInteractionBehaviour behaviour) {
        for (Direction facing : EdgeInteractionHandler.getConnectiveSides(world, pos, face, behaviour)) {
            AABB bb = EdgeInteractionHandler.getBB(pos, facing);
            if (!bb.contains(hit)) continue;
            return facing;
        }
        return null;
    }

    public static AABB getBB(BlockPos pos, Direction direction) {
        AABB bb = new AABB(pos);
        Vec3i vec = direction.getUnitVec3i();
        int x = vec.getX();
        int y = vec.getY();
        int z = vec.getZ();
        double margin = 0.625;
        double absX = (double)Math.abs(x) * margin;
        double absY = (double)Math.abs(y) * margin;
        double absZ = (double)Math.abs(z) * margin;
        bb = bb.contract(absX, absY, absZ);
        bb = bb.move(absX / 2.0, absY / 2.0, absZ / 2.0);
        bb = bb.move((double)x / 2.0, (double)y / 2.0, (double)z / 2.0);
        bb = bb.inflate(0.00390625);
        return bb;
    }
}

