/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettingsHandleBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ServerFilteringBehaviour
extends BlockEntityBehaviour<SmartBlockEntity>
implements ValueSettingsHandleBehaviour {
    public static final BehaviourType<ServerFilteringBehaviour> TYPE = new BehaviourType();
    protected FilterItemStack filter;
    boolean showCount = false;
    public int count = 64;
    public boolean upTo = true;
    private Predicate<ItemStack> predicate = stack -> true;
    private Consumer<ItemStack> callback = stack -> {};
    private Supplier<Boolean> showCountPredicate = () -> this.showCount;
    private Supplier<Boolean> isActive = () -> true;
    boolean recipeFilter = false;
    public boolean fluidFilter = false;

    public ServerFilteringBehaviour(SmartBlockEntity be) {
        super(be);
        this.filter = FilterItemStack.empty();
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.store("Filter", FilterItemStack.CODEC, (Object)this.filter);
        view.putInt("FilterAmount", this.count);
        view.putBoolean("UpTo", this.upTo);
        super.write(view, clientPacket);
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.filter = view.read("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        this.count = view.getIntOr("FilterAmount", 0);
        this.upTo = view.getBooleanOr("UpTo", false);
        if (this.count == 0) {
            this.upTo = true;
            this.count = this.getMaxStackSize();
        }
        super.read(view, clientPacket);
    }

    public ServerFilteringBehaviour withCallback(Consumer<ItemStack> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public ServerFilteringBehaviour withPredicate(Predicate<ItemStack> filterPredicate) {
        this.predicate = filterPredicate;
        return this;
    }

    public ServerFilteringBehaviour forRecipes() {
        this.recipeFilter = true;
        return this;
    }

    public ServerFilteringBehaviour forFluids() {
        this.fluidFilter = true;
        return this;
    }

    public ServerFilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        this.showCountPredicate = condition;
        return this;
    }

    public ServerFilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public boolean setFilter(Direction face, ItemStack stack) {
        return this.setFilter(stack);
    }

    public boolean setFilter(ItemStack stack) {
        ItemStack filter = stack.copy();
        if (!filter.isEmpty() && !this.predicate.test(filter)) {
            return false;
        }
        this.filter = FilterItemStack.of(filter);
        if (!this.upTo) {
            this.count = Math.min(this.count, stack.getMaxStackSize());
        }
        this.callback.accept(filter);
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        return true;
    }

    @Override
    public void setValueSettings(Player player, ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Mth.clamp((int)settings.value(), (int)1, (int)this.getMaxStackSize());
        this.upTo = settings.row() == 0;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(this.upTo ? 0 : 1, this.count == 0 ? this.getMaxStackSize() : this.count);
    }

    @Override
    public void destroy() {
        if (this.filter.isFilterItem()) {
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.getPos());
            Level world = this.getLevel();
            world.addFreshEntity((Entity)new ItemEntity(world, pos.x, pos.y, pos.z, this.getFilter().copy()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (this.filter.isFilterItem()) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.getFilter());
        }
        return ItemRequirement.NONE;
    }

    public int getMaxStackSize() {
        return this.getMaxStackSize(this.getFilter());
    }

    public int getMaxStackSize(Direction face) {
        return this.getMaxStackSize(this.getFilter(face));
    }

    public int getMaxStackSize(ItemStack filter) {
        if (filter.isEmpty()) {
            return 64;
        }
        return filter.getMaxStackSize();
    }

    public ItemStack getFilter(Direction side) {
        return this.getFilter();
    }

    public ItemStack getFilter() {
        return this.filter.item();
    }

    public boolean isCountVisible() {
        return this.showCountPredicate.get() != false && this.getMaxStackSize() > 1;
    }

    public boolean test(ItemStack stack) {
        return !this.isActive() || this.filter.test(this.blockEntity.getLevel(), stack);
    }

    public boolean test(FluidStack stack) {
        return !this.isActive() || this.filter.test(this.blockEntity.getLevel(), stack);
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public ServerFilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    @Override
    public String getClipboardKey() {
        return "Filtering";
    }

    @Override
    public boolean writeToClipboard(ValueOutput view, Direction side) {
        ValueSettingsHandleBehaviour.super.writeToClipboard(view, side);
        ItemStack filter = this.getFilter(side);
        view.store("Filter", ItemStack.OPTIONAL_CODEC, (Object)filter);
        return true;
    }

    @Override
    public boolean readFromClipboard(ValueInput view, Player player, Direction side, boolean simulate) {
        if (!this.mayInteract(player)) {
            return false;
        }
        boolean upstreamResult = ValueSettingsHandleBehaviour.super.readFromClipboard(view, player, side, simulate);
        Optional filterItem = view.read("Filter", ItemStack.OPTIONAL_CODEC);
        if (filterItem.isEmpty()) {
            return upstreamResult;
        }
        if (simulate) {
            return true;
        }
        if (this.getLevel().isClientSide()) {
            return true;
        }
        ItemStack refund = ItemStack.EMPTY;
        ItemStack filter = this.getFilter(side);
        if (filter.getItem() instanceof FilterItem && !player.isCreative()) {
            refund = filter.copy();
        }
        ItemStack copied = (ItemStack)filterItem.get();
        Inventory inventory = player.getInventory();
        Item item = copied.getItem();
        if (item instanceof FilterItem) {
            FilterItem filterType = (FilterItem)item;
            if (!player.isCreative()) {
                if (refund.getItem() == filterType) {
                    this.setFilter(side, copied);
                    return true;
                }
                if (inventory.extract(filterType.getDefaultInstance()) == 1 || !inventory.extract(stack -> stack.getItem() == filterType, 1).isEmpty()) {
                    if (!refund.isEmpty()) {
                        inventory.placeItemBackInInventory(refund);
                    }
                    this.setFilter(side, copied);
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"create.logistics.filter.requires_item_in_inventory", (Object[])new Object[]{copied.getHoverName().copy().withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.RED), true);
                AllSoundEvents.DENY.playOnServer(player.level(), (Vec3i)player.blockPosition(), 1.0f, 1.0f);
                return false;
            }
        }
        if (!refund.isEmpty()) {
            inventory.placeItemBackInInventory(refund);
        }
        return this.setFilter(side, copied);
    }

    @Override
    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack toApply = itemInHand.copy();
        if (!this.canShortInteract(toApply)) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        ItemStack filter = this.getFilter(side);
        if (filter.getItem() instanceof FilterItem) {
            Inventory inventory = player.getInventory();
            if (!player.isCreative() || inventory.count(filter, 1) == 0) {
                inventory.placeItemBackInInventory(filter.copy());
            }
        }
        if (toApply.getItem() instanceof FilterItem) {
            toApply.setCount(1);
        }
        if (!this.setFilter(side, toApply)) {
            player.displayClientMessage((Component)Component.translatable((String)"create.logistics.filter.invalid_item"), true);
            AllSoundEvents.DENY.playOnServer(player.level(), (Vec3i)player.blockPosition(), 1.0f, 1.0f);
            return;
        }
        if (!player.isCreative() && toApply.getItem() instanceof FilterItem) {
            if (itemInHand.getCount() == 1) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                itemInHand.shrink(1);
            }
        }
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    public boolean canShortInteract(ItemStack toApply) {
        if (toApply.is((Item)AllItems.WRENCH)) {
            return false;
        }
        return !toApply.is((Item)AllItems.MECHANICAL_ARM);
    }

    public boolean isRecipeFilter() {
        return this.recipeFilter;
    }

    @Override
    public int netId() {
        return 1;
    }
}

