/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.filtering;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ServerSidedFilteringBehaviour
extends ServerFilteringBehaviour {
    Map<Direction, ServerFilteringBehaviour> sidedFilters;
    private final BiFunction<Direction, ServerFilteringBehaviour, ServerFilteringBehaviour> filterFactory;
    private final Predicate<Direction> validDirections;
    private Consumer<Direction> removeListener;

    public ServerSidedFilteringBehaviour(SmartBlockEntity be, BiFunction<Direction, ServerFilteringBehaviour, ServerFilteringBehaviour> filterFactory, Predicate<Direction> validDirections) {
        super(be);
        this.filterFactory = filterFactory;
        this.validDirections = validDirections;
        this.sidedFilters = new IdentityHashMap<Direction, ServerFilteringBehaviour>();
        this.updateFilterPresence();
    }

    public ServerFilteringBehaviour get(Direction side) {
        return this.sidedFilters.get(side);
    }

    public void updateFilterPresence() {
        HashSet<Direction> valid = new HashSet<Direction>();
        for (Direction d : Iterate.directions) {
            if (!this.validDirections.test(d)) continue;
            valid.add(d);
        }
        for (Direction d : Iterate.directions) {
            if (valid.contains(d)) {
                if (this.sidedFilters.containsKey(d)) continue;
                this.sidedFilters.put(d, this.filterFactory.apply(d, new ServerFilteringBehaviour(this.blockEntity)));
                continue;
            }
            if (!this.sidedFilters.containsKey(d)) continue;
            this.removeFilter(d);
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        ValueOutput.ValueOutputList list = view.childrenList("Filters");
        this.sidedFilters.forEach((side, filter) -> {
            ValueOutput item = list.addChild();
            item.store("Side", (Codec)Direction.CODEC, side);
            filter.write(item, clientPacket);
        });
        super.write(view, clientPacket);
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        view.childrenListOrEmpty("Filters").forEach(item -> {
            Direction side = (Direction)item.read("Side", (Codec)Direction.CODEC).orElseThrow();
            ServerFilteringBehaviour filter = this.sidedFilters.get(side);
            if (filter != null) {
                filter.read((ValueInput)item, clientPacket);
            }
        });
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        this.sidedFilters.values().forEach(BlockEntityBehaviour::tick);
    }

    @Override
    public boolean setFilter(Direction side, ItemStack stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        this.sidedFilters.get(side).setFilter(stack);
        return true;
    }

    @Override
    public ItemStack getFilter(Direction side) {
        if (!this.sidedFilters.containsKey(side)) {
            return ItemStack.EMPTY;
        }
        return this.sidedFilters.get(side).getFilter();
    }

    public boolean test(Direction side, ItemStack stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        return this.sidedFilters.get(side).test(stack);
    }

    @Override
    public void destroy() {
        this.sidedFilters.values().forEach(ServerFilteringBehaviour::destroy);
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.sidedFilters.values().stream().reduce(ItemRequirement.NONE, (a, b) -> a.union(b.getRequiredItems()), ItemRequirement::union);
    }

    public void removeFilter(Direction side) {
        if (!this.sidedFilters.containsKey(side)) {
            return;
        }
        this.sidedFilters.remove(side).destroy();
        if (this.removeListener != null) {
            this.removeListener.accept(side);
        }
    }

    public void setRemoveListener(Consumer<Direction> removeListener) {
        this.removeListener = removeListener;
    }
}

