/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ServerBrassDiodeScrollValueBehaviour
extends ServerScrollValueBehaviour {
    private static final int TICK = 20;
    private static final int MAX_COUNT = 60;
    private static final int MINUTE = 1200;

    public ServerBrassDiodeScrollValueBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Override
    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        if (this.getLevel().isClientSide()) {
            return;
        }
        BlockState blockState = this.blockEntity.getBlockState();
        Block block = blockState.getBlock();
        if (block instanceof BrassDiodeBlock) {
            BrassDiodeBlock bdb = (BrassDiodeBlock)block;
            bdb.toggle(this.getLevel(), this.getPos(), blockState, player, hand);
        }
    }

    @Override
    public void setValueSettings(Player player, ValueSettings valueSetting, boolean ctrlHeld) {
        int multiplier;
        int value = valueSetting.value();
        switch (valueSetting.row()) {
            case 0: {
                int n = 1;
                break;
            }
            case 1: {
                int n = 20;
                break;
            }
            default: {
                int n = multiplier = 1200;
            }
        }
        if (!valueSetting.equals(this.getValueSettings())) {
            this.playFeedbackSound(this);
        }
        this.setValue(Math.max(2, Math.max(1, value) * multiplier));
    }

    @Override
    public ValueSettings getValueSettings() {
        int row = 0;
        int value = this.value;
        if (value > 1200) {
            value /= 1200;
            row = 2;
        } else if (value > 60) {
            value /= 20;
            row = 1;
        }
        return new ValueSettings(row, value);
    }

    @Override
    public String getClipboardKey() {
        return "Timings";
    }
}

