/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.fluid;

import com.zurrtum.create.AllFluidItemInventory;
import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidInventoryCache;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidHelper {
    private static final Map<BlockPos, FluidInventoryCache> INV_CACHE = new Object2ReferenceOpenHashMap();

    public static boolean isWater(Fluid fluid) {
        return FluidHelper.convertToStill(fluid) == Fluids.WATER;
    }

    public static boolean isLava(Fluid fluid) {
        return FluidHelper.convertToStill(fluid) == Fluids.LAVA;
    }

    public static boolean isSame(FluidStack fluidStack, FluidStack fluidStack2) {
        return fluidStack.getFluid() == fluidStack2.getFluid();
    }

    public static boolean isSame(FluidStack fluidStack, Fluid fluid) {
        return fluidStack.getFluid() == fluid;
    }

    public static boolean isTag(Fluid fluid, TagKey<Fluid> tag) {
        return fluid.is(tag);
    }

    public static boolean isTag(FluidState fluid, TagKey<Fluid> tag) {
        return fluid.is(tag);
    }

    public static boolean isTag(FluidStack fluid, TagKey<Fluid> tag) {
        return FluidHelper.isTag(fluid.getFluid(), tag);
    }

    public static SoundEvent getFillSound(FluidStack fluid) {
        SoundEvent soundevent = null;
        if (soundevent == null) {
            soundevent = FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL;
        }
        return soundevent;
    }

    public static SoundEvent getEmptySound(FluidStack fluid) {
        SoundEvent soundevent = null;
        if (soundevent == null) {
            soundevent = FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        return soundevent;
    }

    public static boolean hasBlockState(Fluid fluid) {
        BlockState blockState = fluid.defaultFluidState().createLegacyBlock();
        return blockState != null && blockState != Blocks.AIR.defaultBlockState();
    }

    public static FluidStack copyStackWithAmount(FluidStack fs, int amount) {
        if (amount <= 0) {
            return FluidStack.EMPTY;
        }
        if (fs.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copy = fs.copy();
        copy.setAmount(amount);
        return copy;
    }

    public static Fluid convertToFlowing(Fluid fluid) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowableFluid = (FlowingFluid)fluid;
            return flowableFluid.getFlowing();
        }
        return fluid;
    }

    public static Fluid convertToStill(Fluid fluid) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowableFluid = (FlowingFluid)fluid;
            return flowableFluid.getSource();
        }
        return fluid;
    }

    public static FluidInventory getFluidInventory(Level world, BlockPos pos, Direction direction) {
        return FluidHelper.getFluidInventory(world, pos, null, null, direction);
    }

    public static FluidInventory getFluidInventory(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction) {
        Block block;
        if (state == null) {
            BlockState blockState = state = blockEntity != null ? blockEntity.getBlockState() : world.getBlockState(pos);
        }
        if ((block = state.getBlock()) instanceof FluidInventoryProvider) {
            FluidInventoryProvider provider = (FluidInventoryProvider)block;
            return provider.getFluidInventory(state, (LevelAccessor)world, pos, blockEntity, direction);
        }
        return AllTransfer.getFluidInventory(world, pos, state, blockEntity, direction);
    }

    public static boolean hasFluidInventory(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction) {
        if (state == null) {
            BlockState blockState = state = blockEntity != null ? blockEntity.getBlockState() : world.getBlockState(pos);
        }
        if (state.getBlock() instanceof FluidInventoryProvider) {
            return true;
        }
        return AllTransfer.hasFluidInventory(world, pos, state, blockEntity, direction);
    }

    public static FluidItemInventory getFluidInventory(ItemStack stack) {
        FluidItemInventory inventory = AllFluidItemInventory.of(stack);
        if (inventory != null) {
            return inventory;
        }
        return AllTransfer.getFluidInventory(stack);
    }

    public static boolean hasFluidInventory(ItemStack stack) {
        return AllFluidItemInventory.has(stack) || AllTransfer.hasFluidInventory(stack);
    }

    public static boolean tryEmptyItemIntoBE(Level worldIn, Player player, InteractionHand handIn, ItemStack heldItem, SmartBlockEntity be) {
        if (!GenericItemEmptying.canItemBeEmptied(worldIn, heldItem)) {
            return false;
        }
        FluidInventory capability = FluidHelper.getFluidInventory(worldIn, be.getBlockPos(), null, be, null);
        if (capability == null) {
            return false;
        }
        if (worldIn.isClientSide()) {
            return true;
        }
        Pair<FluidStack, ItemStack> emptyingResult = GenericItemEmptying.emptyItem(worldIn, heldItem, true);
        FluidStack fluidStack = emptyingResult.getFirst();
        if (!capability.preciseInsert(fluidStack, null)) {
            return false;
        }
        ItemStack copyOfHeld = heldItem.copy();
        emptyingResult = GenericItemEmptying.emptyItem(worldIn, copyOfHeld, false);
        if (!player.isCreative() && !(be instanceof CreativeFluidTankBlockEntity)) {
            if (copyOfHeld.isEmpty()) {
                player.setItemInHand(handIn, emptyingResult.getSecond());
            } else {
                player.setItemInHand(handIn, copyOfHeld);
                player.getInventory().placeItemBackInInventory(emptyingResult.getSecond());
            }
        }
        return true;
    }

    public static boolean tryFillItemFromBE(Level world, Player player, InteractionHand handIn, ItemStack heldItem, SmartBlockEntity be) {
        if (!GenericItemFilling.canItemBeFilled(world, heldItem)) {
            return false;
        }
        FluidInventory capability = FluidHelper.getFluidInventory(world, be.getBlockPos(), null, be, null);
        if (capability == null) {
            return false;
        }
        for (FluidStack fluid : capability) {
            int requiredAmountForItem;
            if (fluid.isEmpty() || (requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem(world, heldItem, fluid.copy())) == -1 || requiredAmountForItem > fluid.getAmount()) continue;
            if (world.isClientSide()) {
                return true;
            }
            if (player.isCreative() || be instanceof CreativeFluidTankBlockEntity) {
                heldItem = heldItem.copy();
            }
            ItemStack out = GenericItemFilling.fillItem(world, requiredAmountForItem, heldItem, fluid.copy());
            FluidStack copy = fluid.copy();
            copy.setAmount(requiredAmountForItem);
            capability.extract(copy, null);
            if (!player.isCreative()) {
                player.getInventory().placeItemBackInInventory(out);
            }
            be.notifyUpdate();
            return true;
        }
        return false;
    }

    public static Supplier<FluidInventory> getFluidInventoryCache(ServerLevel world, BlockPos pos, Direction direction) {
        FluidInventoryCache cache = new FluidInventoryCache(world, pos, direction);
        INV_CACHE.put(pos, cache);
        return cache;
    }

    public static void invalidateInventoryCache(BlockPos pos) {
        FluidInventoryCache cache = INV_CACHE.get(pos);
        if (cache != null) {
            cache.invalidate();
        }
    }

    public static enum FluidExchange {
        ITEM_TO_TANK,
        TANK_TO_ITEM;

    }
}

