/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredientSerializer;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;

public record FluidStackIngredient(Fluid fluid, DataComponentPatch components, int amount) implements FluidIngredient
{
    @Override
    public boolean test(FluidStack stack) {
        if (stack.getFluid() != this.fluid) {
            return false;
        }
        if (this.components.isEmpty()) {
            return true;
        }
        return stack.getComponentChanges().map.reference2ObjectEntrySet().containsAll((Collection)this.components.map.reference2ObjectEntrySet());
    }

    @Override
    public List<Fluid> getMatchingFluids() {
        return List.of(this.fluid);
    }

    @Override
    public List<FluidStack> getMatchingFluidStacks() {
        return List.of(new FluidStack(this.fluid, this.amount, this.components));
    }

    @Override
    public FluidIngredientSerializer getSerializer() {
        return FluidIngredientSerializer.FLUID_STACK;
    }

    public record Serializer(String type) implements FluidIngredientSerializer
    {
        public static final MapCodec<FluidStackIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(FluidStackIngredient::fluid), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(FluidStackIngredient::components), (App)Codec.INT.optionalFieldOf("amount", (Object)81000).forGetter(FluidStackIngredient::amount)).apply((Applicative)instance, FluidStackIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidStackIngredient> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), FluidStackIngredient::fluid, (StreamCodec)DataComponentPatch.STREAM_CODEC, FluidStackIngredient::components, (StreamCodec)ByteBufCodecs.INT, FluidStackIngredient::amount, FluidStackIngredient::new);

        public MapCodec<FluidStackIngredient> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidStackIngredient> packetCodec() {
            return PACKET_CODEC;
        }
    }
}

