/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.fluid;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredientSerializer;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;

public record FluidTagIngredient(TagKey<Fluid> tag, int amount) implements FluidIngredient
{
    @Override
    public boolean test(FluidStack stack) {
        return stack.isIn(this.tag);
    }

    @Override
    public List<Fluid> getMatchingFluids() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(this.tag)) {
            Fluid fluid = (Fluid)holder.value();
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)fluid;
                fluid = flowing.getSource();
            }
            builder.add((Object)fluid);
        }
        return builder.build();
    }

    @Override
    public List<FluidStack> getMatchingFluidStacks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(this.tag)) {
            Fluid fluid = (Fluid)holder.value();
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)fluid;
                fluid = flowing.getSource();
            }
            builder.add((Object)new FluidStack(fluid, this.amount));
        }
        return builder.build();
    }

    @Override
    public FluidIngredientSerializer getSerializer() {
        return FluidIngredientSerializer.FLUID_TAG;
    }

    public record Serializer(String type) implements FluidIngredientSerializer
    {
        public static final MapCodec<FluidTagIngredient> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TagKey.hashedCodec((ResourceKey)Registries.FLUID).fieldOf("fluid_tag").forGetter(FluidTagIngredient::tag), (App)Codec.INT.optionalFieldOf("amount", (Object)81000).forGetter(FluidTagIngredient::amount)).apply((Applicative)i, FluidTagIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidTagIngredient> PACKET_CODEC = StreamCodec.composite((StreamCodec)TagKey.streamCodec((ResourceKey)Registries.FLUID), FluidTagIngredient::tag, (StreamCodec)ByteBufCodecs.INT, FluidTagIngredient::amount, FluidTagIngredient::new);

        public MapCodec<FluidTagIngredient> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidTagIngredient> packetCodec() {
            return PACKET_CODEC;
        }
    }
}

