/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.gui.menu;

import com.zurrtum.create.foundation.gui.menu.IClearableMenu;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class GhostItemMenu<T>
extends MenuBase<T>
implements IClearableMenu {
    public ItemStackHandler ghostInventory;

    protected GhostItemMenu(MenuType<T> type, int id, Inventory inv, T contentHolder) {
        super(type, id, inv, contentHolder);
    }

    protected abstract ItemStackHandler createGhostInventory();

    protected abstract boolean allowRepeats();

    @Override
    protected void initAndReadInventory(T contentHolder) {
        this.ghostInventory = this.createGhostInventory();
    }

    @Override
    public void clearContents() {
        int size = this.ghostInventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            this.ghostInventory.setItem(i, ItemStack.EMPTY);
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container == this.playerInventory;
    }

    public boolean canDragTo(Slot slotIn) {
        if (this.allowRepeats()) {
            return true;
        }
        return slotIn.container == this.playerInventory;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack insert;
        if (slotId < 36) {
            super.clicked(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == ClickType.THROW) {
            return;
        }
        ItemStack held = this.getCarried();
        int slot = slotId - 36;
        if (clickTypeIn == ClickType.CLONE) {
            if (player.isCreative() && held.isEmpty()) {
                ItemStack stackInSlot = this.ghostInventory.getItem(slot).copy();
                stackInSlot.setCount(stackInSlot.getMaxStackSize());
                this.setCarried(stackInSlot);
                return;
            }
            return;
        }
        if (held.isEmpty()) {
            insert = ItemStack.EMPTY;
        } else {
            insert = held.copy();
            insert.setCount(1);
        }
        this.ghostInventory.setItem(slot, insert);
        this.getSlot(slotId).setChanged();
    }

    protected boolean moveItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        return false;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index < 36) {
            Slot slot = (Slot)this.slots.get(index);
            ItemStack stackToInsert = slot.getItem();
            int size = this.ghostInventory.getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = this.ghostInventory.getItem(i);
                if (this.allowRepeats() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackToInsert)) {
                    if (!stack.isEmpty()) continue;
                    ItemStack copy = stackToInsert.copy();
                    copy.setCount(1);
                    this.ghostInventory.setItem(i, copy);
                    this.getSlot(i + 36).setChanged();
                }
                break;
            }
        } else {
            int i = index - 36;
            ItemStack stack = this.ghostInventory.getItem(i);
            int count = stack.getCount();
            if (count == 1) {
                this.ghostInventory.setItem(i, ItemStack.EMPTY);
            } else if (count > 1) {
                stack.setCount(count - 1);
            }
            this.getSlot(index).setChanged();
        }
        return ItemStack.EMPTY;
    }
}

