/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.gui.menu;

import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.infrastructure.packet.s2c.OpenScreenPacket;
import io.netty.buffer.Unpooled;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface MenuProvider {
    default public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public MenuBase<?> createMenu(int var1, Inventory var2, Player var3, RegistryFriendlyByteBuf var4);

    default public void openHandledScreen(ServerPlayer player) {
        MenuProvider.openHandledScreen(player, this);
    }

    public static void openHandledScreen(ServerPlayer player, MenuProvider provider) {
        if (player.containerMenu != player.inventoryMenu) {
            player.closeContainer();
        }
        player.nextContainerCounter();
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
        MenuBase<?> menu = provider.createMenu(player.containerCounter, player.getInventory(), (Player)player, buf);
        if (menu == null) {
            if (player.isSpectator()) {
                player.displayClientMessage((Component)Component.translatable((String)"container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            buf.release();
        } else {
            buf.readerIndex(0);
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            buf.release();
            player.connection.send((Packet)new OpenScreenPacket(menu.containerId, menu.getMenuType(), provider.getDisplayName(), data));
            player.initMenu(menu);
            player.containerMenu = menu;
        }
    }
}

