/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.item;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.InventoryCache;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static final Map<BlockPos, InventoryCache> INV_CACHE = new Object2ReferenceOpenHashMap();

    public static boolean sameItem(ItemStack stack, ItemStack otherStack) {
        return !otherStack.isEmpty() && stack.is(otherStack.getItem());
    }

    public static Predicate<ItemStack> sameItemPredicate(ItemStack stack) {
        return s -> ItemHelper.sameItem(stack, s);
    }

    public static List<ItemStack> multipliedOutput(ItemStack out, int count) {
        if (out.isEmpty()) {
            return new ArrayList<ItemStack>(0);
        }
        int total = count * out.getCount();
        int max = out.getMaxStackSize();
        int size = total / max;
        int remaining = total % max;
        boolean hasRemaining = remaining != 0;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(hasRemaining ? size + 1 : size);
        stacks.add(out);
        if (size != 0) {
            out.setCount(max);
            for (int i = 1; i < size; ++i) {
                stacks.add(out.copy());
            }
            if (hasRemaining) {
                stacks.add(out.copyWithCount(remaining));
            }
        } else {
            out.setCount(total);
        }
        return stacks;
    }

    public static List<ItemStack> multipliedOutput(List<ItemStack> out, int count) {
        if (out.isEmpty()) {
            return new ArrayList<ItemStack>(0);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : out) {
            int total = count * stack.getCount();
            int max = (Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64);
            int size = total / max;
            stacks.add(stack);
            if (size != 0) {
                stack.setCount(max);
                for (int i = 1; i < size; ++i) {
                    stacks.add(stack.copy());
                }
                int remaining = total % max;
                if (remaining == 0) continue;
                stacks.add(stack.copyWithCount(remaining));
                continue;
            }
            stack.setCount(total);
        }
        return stacks;
    }

    public static void addToList(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack s : stacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)s)) continue;
            int transferred = Math.min(s.getMaxStackSize() - s.getCount(), stack.getCount());
            s.grow(transferred);
            stack.shrink(transferred);
        }
        if (stack.getCount() > 0) {
            stacks.add(stack);
        }
    }

    public static <T extends IBE<? extends BlockEntity>> int calcRedstoneFromBlockEntity(T ibe, Level level, BlockPos pos) {
        return ibe.getBlockEntityOptional((BlockGetter)level, pos).map(be -> ItemHelper.getInventory(level, pos, null)).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    public static int calcRedstoneFromInventory(@Nullable Container inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        int totalSlots = inv.getContainerSize();
        int size = totalSlots;
        for (int j = 0; j < size; ++j) {
            int slotLimit = inv.getMaxStackSize();
            if (slotLimit == 0) {
                --totalSlots;
                continue;
            }
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(slotLimit, itemstack.getMaxStackSize());
            ++i;
        }
        if (totalSlots == 0) {
            return 0;
        }
        return Mth.floor((float)((f /= (float)totalSlots) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static boolean matchIngredients(Ingredient i1, Ingredient i2) {
        if (i1 == i2) {
            return true;
        }
        HolderSet entries1 = i1.values;
        HolderSet entries2 = i2.values;
        int size = entries1.size();
        if (size == entries2.size()) {
            for (int i = 0; i < size; ++i) {
                if (entries1.contains(entries2.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean matchAllIngredients(List<Ingredient> ingredients) {
        if (ingredients.size() <= 1) {
            return true;
        }
        Ingredient firstIngredient = ingredients.getFirst();
        for (int i = 1; i < ingredients.size(); ++i) {
            if (ItemHelper.matchIngredients(firstIngredient, ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    public static ItemStack extractItem(Container inventory, int slot, int amount, boolean simulate) {
        WorldlyContainer sidedInventory;
        ItemStack stack = inventory.getItem(slot);
        if (stack.isEmpty() || inventory instanceof WorldlyContainer && !(sidedInventory = (WorldlyContainer)inventory).canTakeItemThroughFace(slot, stack, null)) {
            return ItemStack.EMPTY;
        }
        int extract = Math.min(amount, stack.getCount());
        if (simulate) {
            return stack.copyWithCount(extract);
        }
        if (extract == amount) {
            inventory.setItem(slot, ItemStack.EMPTY);
            inventory.setChanged();
            return stack;
        }
        ItemStack result = stack.copy();
        result.setCount(extract);
        stack.shrink(extract);
        inventory.setChanged();
        return result;
    }

    public static boolean canItemStackAmountsStack(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) && a.getCount() + b.getCount() <= a.getMaxStackSize();
    }

    public static ItemStack fromItemEntity(Entity entityIn) {
        ItemStack itemStack;
        if (!entityIn.isAlive()) {
            return ItemStack.EMPTY;
        }
        if (entityIn instanceof PackageEntity) {
            PackageEntity packageEntity = (PackageEntity)entityIn;
            return packageEntity.getBox();
        }
        if (entityIn instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entityIn;
            itemStack = itemEntity.getItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        return itemStack;
    }

    public static void fillItemStackHandler(ItemContainerContents contents, ItemStackHandler inv) {
        List itemStacks = contents.stream().toList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            inv.setItem(i, (ItemStack)itemStacks.get(i));
        }
    }

    public static ItemContainerContents containerContentsFromHandler(ItemStackHandler handler) {
        return ItemContainerContents.fromItems(handler.getStacks());
    }

    public static ItemStack limitCountToMaxStackSize(ItemStack stack, boolean simulate) {
        int max;
        int count = stack.getCount();
        if (count <= (max = stack.getMaxStackSize())) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = stack.copyWithCount(count - max);
        if (!simulate) {
            stack.setCount(max);
        }
        return remainder;
    }

    public static void copyContents(Container from, Container to) {
        if (from.getContainerSize() != to.getContainerSize()) {
            throw new IllegalArgumentException("Slot count mismatch");
        }
        for (int slot = to.getContainerSize() - 1; slot >= 0; --slot) {
            to.setItem(slot, ItemStack.EMPTY);
        }
        for (int i = 0; i < from.getContainerSize(); ++i) {
            to.setItem(i, from.getItem(i).copy());
        }
    }

    public static List<ItemStack> getNonEmptyStacks(ItemStackHandler handler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int size = handler.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = handler.getItem(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static Container getInventory(Level world, BlockPos pos, Direction direction) {
        return ItemHelper.getInventory(world, pos, null, null, direction);
    }

    public static Container getInventory(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction) {
        Block block;
        if (state == null) {
            BlockState blockState = state = blockEntity != null ? blockEntity.getBlockState() : world.getBlockState(pos);
        }
        if ((block = state.getBlock()) instanceof ItemInventoryProvider) {
            ItemInventoryProvider provider = (ItemInventoryProvider)block;
            return provider.getInventory(state, (LevelAccessor)world, pos, blockEntity, direction);
        }
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder provider = (WorldlyContainerHolder)block;
            return provider.getContainer(state, (LevelAccessor)world, pos);
        }
        if (blockEntity == null && state.hasBlockEntity()) {
            blockEntity = world.getBlockEntity(pos);
        }
        if (blockEntity instanceof Container) {
            Container inventory = (Container)blockEntity;
            if (inventory instanceof ChestBlockEntity && block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                inventory = ChestBlock.getContainer((ChestBlock)chestBlock, (BlockState)state, (Level)world, (BlockPos)pos, (boolean)true);
            }
            return inventory;
        }
        return AllTransfer.getInventory(world, pos, state, blockEntity, direction);
    }

    public static Supplier<Container> getInventoryCache(ServerLevel world, BlockPos pos, Direction direction, BiPredicate<BlockEntity, Direction> filter) {
        InventoryCache cache = new InventoryCache(world, pos, direction, filter);
        INV_CACHE.put(pos, cache);
        return cache;
    }

    public static void invalidateInventoryCache(BlockPos pos) {
        InventoryCache cache = INV_CACHE.get(pos);
        if (cache != null) {
            cache.invalidate();
        }
    }

    public static enum ExtractionCountMode {
        EXACTLY,
        UPTO;

    }
}

