/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.pack;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.foundation.data.recipe.Mods;
import com.zurrtum.create.foundation.pack.DynamicPack;
import com.zurrtum.create.foundation.pack.EmptyJsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ConcretePowderBlock;

public class RuntimeDataGenerator {
    private static final Set<String> IGNORES = Set.of("minecraft", "create");
    private static final Pattern STRIPPED_WOODS_PREFIX_REGEX = Pattern.compile("(\\w*)??stripped_(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)()$");
    private static final Pattern STRIPPED_WOOD_SUFFIX_REGEX = Pattern.compile("(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)(\\w*)_stripped(\\w*)");
    private static final Pattern NON_STRIPPED_WOODS_REGEX = Pattern.compile("^(?!stripped_)([a-z_]+)(_log|_wood|_stem|_hyphae|(?<!bioshroom)_block)(([a-z_]+)(?<!_stripped))?$");
    private static final Multimap<Identifier, TagEntry> TAGS = HashMultimap.create();
    private static final Object2ObjectOpenHashMap<Identifier, JsonElement> JSON_FILES = new Object2ObjectOpenHashMap();
    private static final Map<Identifier, Identifier> MISMATCHED_WOOD_NAMES = ImmutableMap.builder().put((Object)Mods.ARS_N.asResource("blue_archwood"), (Object)Mods.ARS_N.asResource("archwood")).put((Object)Mods.DD.asResource("blooming"), (Object)Mods.DD.asResource("bloom")).build();

    public static void insertIntoPack(DynamicPack dynamicPack) {
        Identifier cuttingId = BuiltInRegistries.RECIPE_TYPE.getKey(AllRecipeTypes.CUTTING);
        Identifier splashingId = BuiltInRegistries.RECIPE_TYPE.getKey(AllRecipeTypes.SPLASHING);
        for (Identifier identifier : BuiltInRegistries.ITEM.keySet()) {
            if (IGNORES.contains(identifier.getNamespace())) continue;
            RuntimeDataGenerator.cuttingRecipes(cuttingId, identifier);
            RuntimeDataGenerator.washingRecipes(splashingId, identifier);
        }
        if (!JSON_FILES.isEmpty()) {
            Create.LOGGER.info("Created {} recipes which will be injected into the game", (Object)JSON_FILES.size());
            JSON_FILES.forEach(dynamicPack::put);
            JSON_FILES.clear();
            JSON_FILES.trim();
        }
        if (!TAGS.isEmpty()) {
            Create.LOGGER.info("Created {} tags which will be injected into the game", (Object)TAGS.size());
            for (Map.Entry entry : TAGS.asMap().entrySet()) {
                TagFile tagFile = new TagFile(new ArrayList((Collection)entry.getValue()), false);
                dynamicPack.put(((Identifier)entry.getKey()).withPrefix("tags/item/"), (JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tagFile).result().orElseThrow());
            }
            TAGS.clear();
        }
    }

    private static void cuttingRecipes(Identifier typeId, Identifier itemId) {
        boolean hasFoundMatch;
        String path = itemId.getPath();
        Matcher match = STRIPPED_WOODS_PREFIX_REGEX.matcher(path);
        boolean strippedInPrefix = hasFoundMatch = match.find();
        if (!hasFoundMatch) {
            match = STRIPPED_WOOD_SUFFIX_REGEX.matcher(path);
            hasFoundMatch = match.find();
        }
        boolean noStrippedVariant = false;
        if (!(hasFoundMatch || BuiltInRegistries.ITEM.containsKey(itemId.withPrefix("stripped_")) || BuiltInRegistries.ITEM.containsKey(itemId.withSuffix("_stripped")))) {
            match = NON_STRIPPED_WOODS_REGEX.matcher(path);
            hasFoundMatch = match.find();
            noStrippedVariant = true;
        }
        if (hasFoundMatch) {
            int planksCount;
            String prefix = strippedInPrefix && match.group(1) != null ? match.group(1) : "";
            String suffix = !strippedInPrefix && !noStrippedVariant ? match.group(3) + match.group(4) : "";
            String type = match.group(strippedInPrefix ? 3 : 2);
            Identifier matched_name = itemId.withPath(match.group(strippedInPrefix ? 2 : 1));
            Identifier base = matched_name.withSuffix(type.equals("wood") ? "wood" : "");
            base = MISMATCHED_WOOD_NAMES.getOrDefault(base, base);
            Identifier nonStrippedId = matched_name.withSuffix(type).withPrefix(prefix).withSuffix(suffix);
            Identifier planksId = base.withSuffix("_planks");
            Identifier stairsId = base.withSuffix(base.getNamespace().equals(Mods.BTN.getId()) ? "_planks_stairs" : "_stairs");
            Identifier slabId = base.withSuffix(base.getNamespace().equals(Mods.BTN.getId()) ? "_planks_slab" : "_slab");
            Identifier fenceId = base.withSuffix("_fence");
            Identifier fenceGateId = base.withSuffix("_fence_gate");
            Identifier doorId = base.withSuffix("_door");
            Identifier trapdoorId = base.withSuffix("_trapdoor");
            Identifier pressurePlateId = base.withSuffix("_pressure_plate");
            Identifier buttonId = base.withSuffix("_button");
            Identifier signId = base.withSuffix("_sign");
            int n = planksCount = type.contains("block") ? 3 : 6;
            if (!noStrippedVariant) {
                if (BuiltInRegistries.ITEM.containsKey(nonStrippedId)) {
                    RuntimeDataGenerator.simpleWoodRecipe(typeId, nonStrippedId, itemId);
                }
                RuntimeDataGenerator.simpleWoodRecipe(typeId, itemId, planksId, planksCount);
            } else if (BuiltInRegistries.ITEM.containsKey(planksId)) {
                Identifier tag = Identifier.fromNamespaceAndPath((String)"create", (String)("runtime_generated/compat/" + itemId.getNamespace() + "/" + base.getPath()));
                RuntimeDataGenerator.insertIntoTag(tag, itemId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (Identifier)tag), planksId, planksCount);
            }
            if (!path.contains("_wood") && !path.contains("_hyphae") && BuiltInRegistries.ITEM.containsKey(planksId)) {
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, stairsId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, slabId, 2);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, fenceId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, fenceGateId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, doorId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, trapdoorId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, pressurePlateId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, buttonId);
                RuntimeDataGenerator.simpleWoodRecipe(typeId, planksId, signId);
            }
        }
    }

    private static void washingRecipes(Identifier typeId, Identifier itemId) {
        Block block = (Block)BuiltInRegistries.BLOCK.getValue(itemId);
        if (block instanceof ConcretePowderBlock) {
            ConcretePowderBlock concretePowderBlock = (ConcretePowderBlock)block;
            RuntimeDataGenerator.simpleSplashingRecipe(typeId, itemId, BuiltInRegistries.BLOCK.getKey((Object)concretePowderBlock.concrete));
        }
    }

    private static void insertIntoTag(Identifier tag, Identifier itemId) {
        if (BuiltInRegistries.ITEM.containsKey(itemId)) {
            TAGS.put((Object)tag, (Object)TagEntry.optionalElement((Identifier)itemId));
        }
    }

    private static void simpleWoodRecipe(Identifier typeId, Identifier inputId, Identifier outputId) {
        RuntimeDataGenerator.simpleWoodRecipe(typeId, inputId, outputId, 1);
    }

    private static void simpleWoodRecipe(Identifier typeId, Identifier inputId, Identifier outputId, int amount) {
        if (BuiltInRegistries.ITEM.containsKey(outputId)) {
            RuntimeDataGenerator.addRecipe(typeId, inputId.getNamespace(), inputId.getPath(), outputId.getPath(), new CuttingRecipe(50, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(outputId), amount), Ingredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.getValue(inputId)))));
        }
    }

    private static void simpleWoodRecipe(Identifier typeId, TagKey<Item> inputTag, Identifier outputId, int amount) {
        if (BuiltInRegistries.ITEM.containsKey(outputId)) {
            Recipe.CODEC.encodeStart((DynamicOps)EmptyJsonOps.INSTANCE, (Object)new CuttingRecipe(50, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(outputId), amount), EmptyJsonOps.ofTag(inputTag))).ifSuccess(json -> {
                Identifier inputId = inputTag.location();
                Identifier path = Identifier.fromNamespaceAndPath((String)typeId.getNamespace(), (String)("recipe/" + typeId.getPath() + "/runtime_generated/compat/" + inputId.getNamespace() + "/tag_" + inputId.getPath() + "_to_" + outputId.getPath()));
                JSON_FILES.put((Object)path, json);
            });
        }
    }

    private static void simpleSplashingRecipe(Identifier typeId, Identifier first, Identifier second) {
        RuntimeDataGenerator.addRecipe(typeId, first.getNamespace(), first.getPath(), second.getPath(), new SplashingRecipe(List.of(new ChanceOutput(1.0f, new ItemStack((ItemLike)BuiltInRegistries.BLOCK.getValue(second)))), Ingredient.of((ItemLike)((ItemLike)BuiltInRegistries.BLOCK.getValue(first)))));
    }

    private static void addRecipe(Identifier typeId, String modid, String from, String to, Recipe<?> recipe) {
        Recipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, recipe).ifSuccess(json -> {
            Identifier path = Identifier.fromNamespaceAndPath((String)typeId.getNamespace(), (String)("recipe/" + typeId.getPath() + "/runtime_generated/compat/" + modid + "/" + from + "_to_" + to));
            JSON_FILES.put((Object)path, json);
        });
    }
}

