/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import org.jetbrains.annotations.Nullable;

public class ComponentsIngredient
extends Ingredient {
    public static final String TYPE_KEY = "fabric:type";
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"fabric", (String)"components");
    public static final String STRING_ID = ID.toString();
    public static final Codec<ComponentsIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Identifier.CODEC.optionalFieldOf(TYPE_KEY).forGetter(i -> Optional.of(ID)), (App)Ingredient.CODEC.fieldOf("base").forGetter(ComponentsIngredient::getBase), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(ComponentsIngredient::getComponents)).apply((Applicative)instance, (id, base, components) -> new ComponentsIngredient((Ingredient)base, (DataComponentPatch)components)));
    public static final StreamCodec<RegistryFriendlyByteBuf, ComponentsIngredient> CONTENTS_STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ComponentsIngredient::getBase, (StreamCodec)DataComponentPatch.STREAM_CODEC, ComponentsIngredient::getComponents, ComponentsIngredient::new);
    private final Ingredient base;
    private final DataComponentPatch components;

    public ComponentsIngredient(Ingredient base, DataComponentPatch components) {
        super((HolderSet)HolderSet.direct((Holder[])new Holder[]{Items.STONE.builtInRegistryHolder()}));
        if (components.isEmpty()) {
            throw new IllegalArgumentException("ComponentIngredient must have at least one defined component");
        }
        this.base = base;
        this.components = components;
    }

    public Stream<Holder<Item>> items() {
        return this.base.items();
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    public boolean test(ItemStack stack) {
        if (!this.base.test(stack)) {
            return false;
        }
        for (Map.Entry entry : this.components.entrySet()) {
            DataComponentType type = (DataComponentType)entry.getKey();
            Optional value = (Optional)entry.getValue();
            if (value.isPresent()) {
                if (!stack.has(type)) {
                    return false;
                }
                if (Objects.equals(value.get(), stack.get(type))) continue;
                return false;
            }
            if (!stack.has(type)) continue;
            return false;
        }
        return true;
    }

    public boolean acceptsItem(Holder<Item> registryEntry) {
        return this.base.acceptsItem(registryEntry);
    }

    private Ingredient getBase() {
        return this.base;
    }

    @Nullable
    private DataComponentPatch getComponents() {
        return this.components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ComponentsIngredient that = (ComponentsIngredient)((Object)o);
        return this.base.equals((Object)that.base) && this.components.equals((Object)that.components);
    }

    public SlotDisplay display() {
        return new SlotDisplay.Composite(this.base.items().map(this::createEntryDisplay).toList());
    }

    private SlotDisplay createEntryDisplay(Holder<Item> entry) {
        ItemStack stack = ((Item)entry.value()).getDefaultInstance();
        stack.applyComponentsAndValidate(this.components);
        return new SlotDisplay.ItemStackSlotDisplay(stack);
    }
}

