/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientTextContent
implements ComponentContents {
    private static final Codec<TagKey<Item>> TAG_CODEC = TagKey.hashedCodec((ResourceKey)Registries.ITEM);
    private static final Codec<List<Holder<Item>>> ENTRY_CODEC = Item.CODEC.listOf();
    private static final Codec<Ingredient> INGREDIENT_CODEC = new Codec<Ingredient>(){

        public <T> DataResult<Pair<Ingredient, T>> decode(DynamicOps<T> ops, T input) {
            Optional list;
            DataResult tag;
            RegistryOps registryOps;
            Optional entryLookup;
            if (ops instanceof RegistryOps && (entryLookup = (registryOps = (RegistryOps)ops).getter(Registries.ITEM)).isPresent() && (tag = TAG_CODEC.decode(ops, input)).isSuccess() && (list = ((HolderGetter)entryLookup.get()).get((TagKey)((Pair)tag.getOrThrow()).getFirst())).isPresent()) {
                return tag.map(pair -> pair.mapFirst(i -> new Ingredient((HolderSet)list.get())));
            }
            DataResult entry = Item.CODEC.decode(ops, input);
            if (entry.isSuccess()) {
                return entry.map(pair -> pair.mapFirst(value -> new Ingredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{value}))));
            }
            return ENTRY_CODEC.decode(ops, input).map(pair -> pair.mapFirst(value -> new Ingredient((HolderSet)HolderSet.direct((List)value))));
        }

        public <T> DataResult<T> encode(Ingredient input, DynamicOps<T> ops, T prefix) {
            DataResult result;
            Optional tag;
            HolderSet entries = input.values;
            if (ops instanceof RegistryOps && (tag = entries.unwrapKey()).isPresent() && (result = TAG_CODEC.encode((Object)((TagKey)tag.get()), ops, prefix)).isSuccess()) {
                return result;
            }
            List list = entries.stream().toList();
            if (list.size() == 1) {
                return Item.CODEC.encode((Object)((Holder)list.getFirst()), ops, prefix);
            }
            return ENTRY_CODEC.encode(list, ops, prefix);
        }
    };
    public static final MapCodec<IngredientTextContent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)INGREDIENT_CODEC.optionalFieldOf("ingredient").forGetter(i -> Optional.ofNullable(i.ingredient)), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(i -> Optional.ofNullable(i.name))).apply((Applicative)instance, IngredientTextContent::new));
    public Ingredient ingredient;
    public Component name;

    public MapCodec<? extends ComponentContents> codec() {
        return CODEC;
    }

    public IngredientTextContent(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public IngredientTextContent(Optional<Ingredient> ingredient, Optional<Component> name) {
        name.ifPresentOrElse(value -> {
            this.name = value;
        }, () -> {
            this.ingredient = ingredient.orElse(null);
        });
    }

    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
        if (this.name != null) {
            return this.name.visit(visitor);
        }
        return this.findName().flatMap(text -> text.visit(visitor));
    }

    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> visitor, Style style) {
        if (this.name != null) {
            return this.name.visit(visitor, style);
        }
        return this.findName().flatMap(text -> text.visit(visitor, style));
    }

    private Optional<Component> findName() {
        Optional first;
        if (this.ingredient != null && this.ingredient.values.isBound() && (first = this.ingredient.values.stream().findFirst()).isPresent()) {
            this.name = ((Item)((Holder)first.get()).value()).getName();
            this.ingredient = null;
            return Optional.of(this.name);
        }
        return Optional.empty();
    }

    public Optional<Component> getName() {
        if (this.name != null) {
            return Optional.of(this.name);
        }
        return this.findName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IngredientTextContent) {
            IngredientTextContent other = (IngredientTextContent)obj;
            Optional<Component> name = this.getName();
            Optional<Component> otherName = other.getName();
            if (name.isPresent() && otherName.isPresent()) {
                return name.get().equals((Object)otherName.get());
            }
            return true;
        }
        return false;
    }
}

