/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.recipe;

import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.items.BaseInventory;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RecipeApplier {
    public static <T extends RecipeInput> void applyCreateRecipeOn(ItemEntity entity, T input, CreateRecipe<T> recipe, boolean returnProcessingRemainder) {
        Level world = entity.level();
        List<ItemStack> stacks = RecipeApplier.applyCreateRecipeOn(entity.level(), entity.getItem().getCount(), input, recipe, returnProcessingRemainder);
        int size = stacks.size();
        if (size == 0) {
            entity.discard();
            return;
        }
        entity.setItem(stacks.getFirst());
        if (size == 1) {
            return;
        }
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        Vec3 velocity = entity.getDeltaMovement();
        for (int i = 1; i < size; ++i) {
            ItemEntity entityIn = new ItemEntity(world, x, y, z, stacks.get(i));
            entityIn.setDeltaMovement(velocity);
            world.addFreshEntity((Entity)entityIn);
        }
    }

    public static <T extends RecipeInput> List<ItemStack> applyCreateRecipeOn(Level world, int count, T input, CreateRecipe<T> recipe, boolean returnProcessingRemainder) {
        ArrayList<ItemStack> remainders;
        if (returnProcessingRemainder) {
            remainders = new ArrayList<ItemStack>();
            int size = input.size();
            for (int i = 0; i < size; ++i) {
                ItemStack recipeRemainder = input.getItem(i).getItem().getCraftingRemainder();
                if (recipeRemainder.isEmpty()) continue;
                remainders.add(recipeRemainder);
            }
            if (remainders.isEmpty()) {
                remainders = null;
            }
        } else {
            remainders = null;
        }
        if (recipe.isRollable()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            Object2ObjectOpenCustomHashMap buffer = new Object2ObjectOpenCustomHashMap(BaseInventory.ITEM_STACK_HASH_STRATEGY);
            for (int i = 0; i < count; ++i) {
                RecipeApplier.updateBuffer((Object2ObjectMap<ItemStack, ObjectIntPair<ItemStack>>)buffer, recipe.assemble(input, world.random), stacks);
                if (remainders == null) continue;
                RecipeApplier.updateBuffer((Object2ObjectMap<ItemStack, ObjectIntPair<ItemStack>>)buffer, remainders, stacks);
            }
            buffer.values().stream().map(Pair::left).filter(stack -> !stack.isEmpty()).forEach(stacks::add);
            return stacks;
        }
        List<ItemStack> craft = recipe.assemble(input, world.random);
        if (remainders != null) {
            remainders.addAll(craft);
            return ItemHelper.multipliedOutput(remainders, count);
        }
        return ItemHelper.multipliedOutput(craft, count);
    }

    private static void updateBuffer(Object2ObjectMap<ItemStack, ObjectIntPair<ItemStack>> buffer, List<ItemStack> insert, List<ItemStack> outputs) {
        for (ItemStack stack : insert) {
            ObjectIntPair item = (ObjectIntPair)buffer.get((Object)stack);
            if (item == null) {
                buffer.put((Object)stack, (Object)ObjectIntPair.of((Object)stack, (int)stack.getMaxStackSize()));
                continue;
            }
            int max = item.rightInt();
            ItemStack exist = (ItemStack)item.left();
            int amount = stack.getCount() + exist.getCount();
            if (amount >= max) {
                exist.setCount(amount - max);
                stack.setCount(max);
                outputs.add(stack);
                continue;
            }
            exist.setCount(amount);
        }
    }

    public static <T extends RecipeInput> List<ItemStack> applyRecipeOn(Level level, int count, T input, RecipeHolder<? extends Recipe<T>> entry, boolean returnProcessingRemainder) {
        Recipe recipe = entry.value();
        if (recipe instanceof CreateRecipe) {
            CreateRecipe createRecipe = (CreateRecipe)recipe;
            return RecipeApplier.applyCreateRecipeOn(level, count, input, createRecipe, returnProcessingRemainder);
        }
        return RecipeApplier.applyRecipeOn(level, count, input, recipe, returnProcessingRemainder);
    }

    public static <T extends RecipeInput> List<ItemStack> applyRecipeOn(Level level, int count, T input, Recipe<T> recipe, boolean returnProcessingRemainder) {
        ItemStack result = recipe.assemble(input, (HolderLookup.Provider)level.registryAccess());
        if (returnProcessingRemainder) {
            int size = input.size();
            if (size != 1) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < size; ++i) {
                    ItemStack recipeRemainder = input.getItem(i).getItem().getCraftingRemainder();
                    if (recipeRemainder.isEmpty()) continue;
                    list.add(recipeRemainder);
                }
                list.add(result);
                return ItemHelper.multipliedOutput(list, count);
            }
            ItemStack recipeRemainder = input.getItem(0).getItem().getCraftingRemainder();
            if (!recipeRemainder.isEmpty()) {
                return ItemHelper.multipliedOutput(List.of(result, recipeRemainder), count);
            }
        }
        return ItemHelper.multipliedOutput(result, count);
    }
}

