/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.impl.contraption.dispenser;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedProjectileDispenseBehavior;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public enum DispenserBehaviorConverter implements SimpleRegistry.Provider<Item, MountedDispenseBehavior>
{
    INSTANCE;


    @Override
    @Nullable
    public MountedDispenseBehavior get(Item item, Level world) {
        DispenseItemBehavior vanilla = ((DispenserBlock)Blocks.DISPENSER).getDispenseMethod(world, item.getDefaultInstance());
        if (vanilla == null) {
            return null;
        }
        if (vanilla.getClass() == DefaultDispenseItemBehavior.class) {
            return null;
        }
        if (item.builtInRegistryHolder().is(AllItemTags.DISPENSE_BEHAVIOR_WRAP_BLACKLIST)) {
            return null;
        }
        if (vanilla instanceof ProjectileDispenseBehavior) {
            ProjectileDispenseBehavior projectile = (ProjectileDispenseBehavior)vanilla;
            return MountedProjectileDispenseBehavior.of(projectile);
        }
        return new FallbackBehavior(item, vanilla);
    }

    @Override
    @Nullable
    public MountedDispenseBehavior get(Item item) {
        Create.LOGGER.warn("Requires World parameter");
        return null;
    }

    @Override
    public void onRegister(Runnable invalidate) {
    }

    private static final class FallbackBehavior
    extends DefaultMountedDispenseBehavior {
        private final Item item;
        private final DispenseItemBehavior wrapped;
        private boolean hasErrored;

        private FallbackBehavior(Item item, DispenseItemBehavior wrapped) {
            this.item = item;
            this.wrapped = wrapped;
        }

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            if (this.hasErrored) {
                return stack;
            }
            MinecraftServer server = context.world.getServer();
            ServerLevel serverLevel = server != null ? server.getLevel(context.world.dimension()) : null;
            Direction nearestFacing = MountedDispenseBehavior.getClosestFacingDirection(facing);
            BlockState state = context.state;
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)nearestFacing);
            }
            BlockSource source = new BlockSource(serverLevel, pos, state, null);
            try {
                return this.wrapped.dispense(source, stack.copy());
            }
            catch (NullPointerException e) {
                Identifier itemId = BuiltInRegistries.ITEM.getKey((Object)this.item);
                String message = "Error dispensing item '" + String.valueOf(itemId) + "' from contraption, not doing that anymore";
                Create.LOGGER.error(message, (Throwable)e);
                this.hasErrored = true;
                return stack;
            }
        }
    }
}

