/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.impl.effect;

import com.zurrtum.create.api.effect.OpenPipeEffectHandler;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class PotionEffectHandler
implements OpenPipeEffectHandler {
    @Override
    public void apply(Level level, AABB area, FluidStack fluid) {
        PotionContents contents = PotionEffectHandler.getContents(fluid);
        if (contents == PotionContents.EMPTY) {
            return;
        }
        List entities = level.getEntitiesOfClass(LivingEntity.class, area, LivingEntity::isAffectedByPotions);
        for (LivingEntity entity : entities) {
            contents.forEachEffect(effectInstance -> {
                MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                if (effect.isInstantenous()) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        effect.applyInstantenousEffect(serverWorld, null, null, entity, effectInstance.getAmplifier(), 0.5);
                    }
                } else {
                    entity.addEffect(new MobEffectInstance(effectInstance));
                }
            }, 1.0f);
        }
    }

    private static PotionContents getContents(FluidStack fluid) {
        FluidStack copy = fluid.copy();
        copy.setAmount(27000);
        ItemStack bottle = PotionFluidHandler.fillBottle(new ItemStack((ItemLike)Items.GLASS_BOTTLE), copy);
        return (PotionContents)bottle.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }
}

