/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import java.util.List;
import java.util.Random;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record SequencedAssemblyJunk(float chance, List<ChanceOutput> junks) {
    public static final Codec<SequencedAssemblyJunk> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("chance").forGetter(SequencedAssemblyJunk::chance), (App)ChanceOutput.CODEC.listOf().fieldOf("junks").forGetter(SequencedAssemblyJunk::junks)).apply((Applicative)instance, SequencedAssemblyJunk::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SequencedAssemblyJunk> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, SequencedAssemblyJunk::chance, (StreamCodec)ChanceOutput.PACKET_CODEC.apply(ByteBufCodecs.list()), SequencedAssemblyJunk::junks, SequencedAssemblyJunk::new);
    public static final Random random = new Random();

    public boolean hasJunk() {
        return random.nextFloat() > this.chance;
    }

    public ItemStack getJunk() {
        if (this.junks.isEmpty()) {
            return ItemStack.EMPTY;
        }
        float totalWeight = 0.0f;
        for (ChanceOutput junk : this.junks) {
            totalWeight += junk.chance();
        }
        float number = random.nextFloat() * totalWeight;
        for (ChanceOutput junk : this.junks) {
            if (!((number -= junk.chance()) < 0.0f)) continue;
            return junk.stack().copy();
        }
        return ItemStack.EMPTY;
    }
}

