/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class SymmetryMirror {
    public static final String EMPTY = "empty";
    public static final String PLANE = "plane";
    public static final String CROSS_PLANE = "cross_plane";
    public static final String TRIPLE_PLANE = "triple_plane";
    public static final Codec<SymmetryMirror> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("orientation_index").forGetter(SymmetryMirror::getOrientationIndex), (App)Vec3.CODEC.fieldOf("position").forGetter(SymmetryMirror::getPosition), (App)Codec.STRING.fieldOf("type").forGetter(SymmetryMirror::typeName), (App)Codec.BOOL.fieldOf("enable").forGetter(m -> m.enable)).apply((Applicative)i, SymmetryMirror::create));
    public static final StreamCodec<FriendlyByteBuf, SymmetryMirror> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SymmetryMirror::getOrientationIndex, (StreamCodec)Vec3.STREAM_CODEC, SymmetryMirror::getPosition, (StreamCodec)ByteBufCodecs.STRING_UTF8, SymmetryMirror::typeName, (StreamCodec)ByteBufCodecs.BOOL, m -> m.enable, SymmetryMirror::create);
    protected Vec3 position;
    public StringRepresentable orientation;
    protected int orientationIndex;
    public boolean enable;

    public SymmetryMirror(Vec3 pos) {
        this.position = pos;
        this.enable = true;
        this.orientationIndex = 0;
    }

    private static SymmetryMirror create(Integer orientationIndex, Vec3 position, String type, Boolean enable) {
        SymmetryMirror element = switch (type) {
            case PLANE -> new PlaneMirror(position);
            case CROSS_PLANE -> new CrossPlaneMirror(position);
            case TRIPLE_PLANE -> new TriplePlaneMirror(position);
            default -> new EmptyMirror(position);
        };
        element.setOrientation(orientationIndex);
        element.enable = enable;
        return element;
    }

    public StringRepresentable getOrientation() {
        return this.orientation;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public int getOrientationIndex() {
        return this.orientationIndex;
    }

    public void rotate(boolean forward) {
        this.orientationIndex += forward ? 1 : -1;
        this.setOrientation();
    }

    public void process(Map<BlockPos, Pair<Direction, BlockState>> blocks) {
        HashMap<BlockPos, Pair<Direction, BlockState>> result = new HashMap<BlockPos, Pair<Direction, BlockState>>();
        for (BlockPos pos : blocks.keySet()) {
            result.putAll(this.process(pos, blocks.get(pos)));
        }
        blocks.putAll(result);
    }

    public void process(Set<BlockPos> positions) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (BlockPos pos : positions) {
            result.addAll(this.process(pos));
        }
        positions.addAll(result);
    }

    public abstract Map<BlockPos, Pair<Direction, BlockState>> process(BlockPos var1, Pair<Direction, BlockState> var2);

    public abstract Set<BlockPos> process(BlockPos var1);

    protected abstract void setOrientation();

    public abstract void setOrientation(int var1);

    public abstract String typeName();

    protected Vec3 getDiff(BlockPos position) {
        return this.position.scale(-1.0).add((double)position.getX(), (double)position.getY(), (double)position.getZ());
    }

    protected BlockPos getIDiff(BlockPos position) {
        Vec3 diff = this.getDiff(position);
        return new BlockPos((int)diff.x, (int)diff.y, (int)diff.z);
    }

    protected BlockState flipX(BlockState in) {
        return in.mirror(Mirror.FRONT_BACK);
    }

    protected BlockState flipZ(BlockState in) {
        return in.mirror(Mirror.LEFT_RIGHT);
    }

    protected BlockState flipD1(BlockState in) {
        return in.rotate(Rotation.COUNTERCLOCKWISE_90).mirror(Mirror.FRONT_BACK);
    }

    protected BlockState flipD2(BlockState in) {
        return in.rotate(Rotation.COUNTERCLOCKWISE_90).mirror(Mirror.LEFT_RIGHT);
    }

    protected BlockPos flipX(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.getX() - 2 * diff.getX(), position.getY(), position.getZ());
    }

    protected BlockPos flipY(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.getX(), position.getY() - 2 * diff.getY(), position.getZ());
    }

    protected BlockPos flipZ(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.getX(), position.getY(), position.getZ() - 2 * diff.getZ());
    }

    protected BlockPos flipD2(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.getX() - diff.getX() + diff.getZ(), position.getY(), position.getZ() - diff.getZ() + diff.getX());
    }

    protected BlockPos flipD1(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.getX() - diff.getX() - diff.getZ(), position.getY(), position.getZ() - diff.getZ() - diff.getX());
    }

    protected Direction flipZ(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST -> side;
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
        };
    }

    protected Direction flipX(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH -> side;
            case Direction.EAST -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
        };
    }

    protected Direction flipXZ(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
            case Direction.EAST -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
        };
    }

    protected Direction flipD1(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.NORTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.SOUTH;
        };
    }

    protected Direction flipD2(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.NORTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
        };
    }

    protected Direction flipD1D2(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
            case Direction.EAST -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
        };
    }

    protected Direction flipD1X(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH -> side.getClockWise();
        };
    }

    protected Direction flipD1Z(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH -> side.getCounterClockWise();
        };
    }

    protected Direction flipD1XZ(Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> side;
            case Direction.NORTH -> Direction.WEST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.WEST -> Direction.NORTH;
        };
    }

    public void setPosition(Vec3 pos3d) {
        this.position = pos3d;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetryMirror)) {
            return false;
        }
        SymmetryMirror that = (SymmetryMirror)o;
        return this.getOrientationIndex() == that.getOrientationIndex() && this.enable == that.enable && Objects.equals(this.getPosition(), that.getPosition()) && Objects.equals(this.getOrientation(), that.getOrientation());
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getPosition());
        result = 31 * result + Objects.hashCode(this.getOrientation());
        result = 31 * result + this.getOrientationIndex();
        result = 31 * result + Boolean.hashCode(this.enable);
        return result;
    }
}

