/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.equipment.zapper.ZapperItem;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.FlattenTool;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TerrainTools implements StringRepresentable
{
    Fill,
    Place,
    Replace,
    Clear,
    Overlay,
    Flatten;

    public static final Codec<TerrainTools> CODEC;
    public static final StreamCodec<ByteBuf, TerrainTools> STREAM_CODEC;
    public final String translationKey = this.name().toLowerCase(Locale.ROOT);

    @NotNull
    public String getSerializedName() {
        return this.translationKey;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear && this != Flatten;
    }

    public void run(Level world, List<BlockPos> targetPositions, Direction facing, @Nullable BlockState paintedState, @Nullable CompoundTag data, Player player) {
        switch (this.ordinal()) {
            case 3: {
                targetPositions.forEach(p -> world.setBlockAndUpdate(p, Blocks.AIR.defaultBlockState()));
                break;
            }
            case 0: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.getBlockState(p);
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.setBlockAndUpdate(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case 5: {
                FlattenTool.apply(world, targetPositions, facing);
                break;
            }
            case 4: {
                targetPositions.forEach(p -> {
                    BlockState toOverlay = world.getBlockState(p);
                    if (TerrainTools.isReplaceable(toOverlay)) {
                        return;
                    }
                    if (toOverlay == paintedState) {
                        return;
                    }
                    BlockState toReplace = world.getBlockState(p = p.above());
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.setBlockAndUpdate(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case 1: {
                targetPositions.forEach(p -> {
                    world.setBlockAndUpdate(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case 2: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.getBlockState(p);
                    if (TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.setBlockAndUpdate(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
            }
        }
    }

    public static boolean isReplaceable(BlockState toReplace) {
        return toReplace.canBeReplaced();
    }

    static {
        CODEC = StringRepresentable.fromEnum(TerrainTools::values);
        STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(TerrainTools.class);
    }
}

