/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventoryWrapper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;

public class BucketFluidInventory
extends FluidItemInventoryWrapper {
    public static final int CAPACITY = 81000;

    @Override
    public int getMaxAmountPerStack() {
        return 81000;
    }

    public ItemStack toFillBucket(FluidStack stack) {
        if (stack.isOf((Fluid)AllFluids.MILK)) {
            return Items.MILK_BUCKET.getDefaultInstance();
        }
        return stack.getFluid().getBucket().getDefaultInstance();
    }

    public Fluid toFluid() {
        if (this.stack.is(Items.MILK_BUCKET)) {
            return AllFluids.MILK;
        }
        return ((BucketItem)this.stack.getItem()).content;
    }

    @Override
    public boolean canInsert() {
        Item item = this.stack.getItem();
        return item == Items.BUCKET || item == Items.AIR;
    }

    @Override
    public boolean canExtract() {
        Item item = this.stack.getItem();
        return item != Items.BUCKET && item != Items.AIR;
    }

    @Override
    public int insert(FluidStack stack) {
        return this.insert(stack, stack.getAmount());
    }

    @Override
    public int insert(FluidStack stack, int maxAmount) {
        if (!this.canInsert() || maxAmount < 81000) {
            return 0;
        }
        ItemStack bucket = this.toFillBucket(stack);
        if (bucket.isEmpty()) {
            return 0;
        }
        this.stack = bucket;
        return 81000;
    }

    @Override
    public boolean preciseInsert(FluidStack stack) {
        return this.insert(stack) == 81000;
    }

    @Override
    public int count(FluidStack stack) {
        Item item = this.stack.getItem();
        if (item == Items.BUCKET || item == Items.AIR || stack.getFluid() != this.toFluid()) {
            return 0;
        }
        return 81000;
    }

    @Override
    public int count(FluidStack stack, int maxAmount) {
        if (maxAmount < 81000) {
            return 0;
        }
        return this.count(stack);
    }

    @Override
    public int countSpace(FluidStack stack) {
        ItemStack bucket = this.toFillBucket(stack);
        if (bucket.isEmpty()) {
            return 0;
        }
        return this.canInsert() ? 81000 : 0;
    }

    @Override
    public int countSpace(FluidStack stack, int maxAmount) {
        if (maxAmount < 81000) {
            return 0;
        }
        return this.countSpace(stack);
    }

    @Override
    public int extract(FluidStack stack) {
        return this.extract(stack, stack.getAmount());
    }

    @Override
    public int extract(FluidStack stack, int maxAmount) {
        if (!this.canExtract() || maxAmount != 81000 || stack.getFluid() != this.toFluid()) {
            return 0;
        }
        this.stack = Items.BUCKET.getDefaultInstance();
        return 81000;
    }

    @Override
    public FluidStack extractAny(int maxAmount) {
        if (!this.canExtract() || maxAmount != 81000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = new FluidStack(this.toFluid(), 81000);
        this.stack = Items.BUCKET.getDefaultInstance();
        return fluid;
    }

    @Override
    public boolean preciseExtract(FluidStack stack) {
        return this.extract(stack) == 81000;
    }

    @Override
    public FluidStack getStack() {
        Item item = this.stack.getItem();
        if (item == Items.BUCKET || item == Items.AIR) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.toFluid(), 81000);
    }

    @Override
    public void setStack(FluidStack stack) {
        this.stack = stack.getAmount() >= 81000 ? this.toFillBucket(stack) : Items.BUCKET.getDefaultInstance();
    }

    @Override
    public FluidStack removeStack() {
        Item item = this.stack.getItem();
        if (item == Items.BUCKET || item == Items.AIR) {
            return FluidStack.EMPTY;
        }
        this.stack = Items.BUCKET.getDefaultInstance();
        return new FluidStack(this.toFluid(), 81000);
    }

    @Override
    public FluidStack removeStackWithAmount(int amount) {
        if (amount != 81000) {
            return FluidStack.EMPTY;
        }
        return this.removeStack();
    }
}

