/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllFluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class FluidInteractionRegistry {
    public static final Map<Fluid, List<InteractionInformation>> INTERACTIONS = new HashMap<Fluid, List<InteractionInformation>>();

    public static synchronized void addInteraction(Fluid source, InteractionInformation interaction) {
        if (source instanceof FlowingFluid) {
            FlowingFluid flowableFluid = (FlowingFluid)source;
            INTERACTIONS.computeIfAbsent(flowableFluid.getSource(), s -> new ArrayList()).add(interaction);
            INTERACTIONS.computeIfAbsent(flowableFluid.getFlowing(), s -> new ArrayList()).add(interaction);
        } else {
            INTERACTIONS.computeIfAbsent(source, s -> new ArrayList()).add(interaction);
        }
    }

    public static boolean canInteract(Level level, BlockPos pos) {
        FluidState state = level.getFluidState(pos);
        List interactions = INTERACTIONS.getOrDefault(state.getType(), Collections.emptyList());
        for (Direction direction : LiquidBlock.POSSIBLE_FLOW_DIRECTIONS) {
            BlockPos relativePos = pos.relative(direction.getOpposite());
            for (InteractionInformation interaction : interactions) {
                if (!interaction.predicate().test(level, pos, relativePos, state)) continue;
                interaction.interaction().interact(level, pos, relativePos, state);
                return true;
            }
        }
        return false;
    }

    static {
        FluidInteractionRegistry.addInteraction((Fluid)Fluids.LAVA, new InteractionInformation((Fluid)Fluids.WATER, fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((Fluid)Fluids.LAVA, new InteractionInformation((level, currentPos, relativePos, currentState) -> level.getBlockState(currentPos.below()).is(Blocks.SOUL_SOIL) && level.getBlockState(relativePos).is(Blocks.BLUE_ICE), Blocks.BASALT.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((Fluid)Fluids.LAVA, new InteractionInformation((Fluid)AllFluids.HONEY, fluidState -> {
            if (fluidState.isSource()) {
                return Blocks.OBSIDIAN.defaultBlockState();
            }
            return AllBlocks.LIMESTONE.defaultBlockState();
        }));
        FluidInteractionRegistry.addInteraction((Fluid)Fluids.LAVA, new InteractionInformation((Fluid)AllFluids.CHOCOLATE, fluidState -> {
            if (fluidState.isSource()) {
                return Blocks.OBSIDIAN.defaultBlockState();
            }
            return AllBlocks.SCORIA.defaultBlockState();
        }));
    }

    public record InteractionInformation(HasFluidInteraction predicate, FluidInteraction interaction) {
        public InteractionInformation(Fluid type, BlockState state) {
            this(type, (FluidState fluidState) -> state);
        }

        public InteractionInformation(HasFluidInteraction predicate, BlockState state) {
            this(predicate, (FluidState fluidState) -> state);
        }

        public InteractionInformation(Fluid type, Function<FluidState, BlockState> getState) {
            this((Level level, BlockPos currentPos, BlockPos relativePos, FluidState currentState) -> {
                FluidState state = level.getFluidState(relativePos);
                Fluid fluid = state.getType();
                if (!fluid.isSource(state) && fluid instanceof FlowingFluid) {
                    FlowingFluid flowableFluid = (FlowingFluid)fluid;
                    fluid = flowableFluid.getSource();
                }
                return fluid == type;
            }, getState);
        }

        public InteractionInformation(HasFluidInteraction predicate, Function<FluidState, BlockState> getState) {
            this(predicate, (Level level, BlockPos currentPos, BlockPos relativePos, FluidState currentState) -> {
                level.setBlockAndUpdate(currentPos, (BlockState)getState.apply(currentState));
                level.levelEvent(1501, currentPos, 0);
            });
        }
    }

    @FunctionalInterface
    public static interface HasFluidInteraction {
        public boolean test(Level var1, BlockPos var2, BlockPos var3, FluidState var4);
    }

    @FunctionalInterface
    public static interface FluidInteraction {
        public void interact(Level var1, BlockPos var2, BlockPos var3, FluidState var4);
    }
}

