/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public interface BaseInventory
extends Iterable<ItemStack> {
    public static final Hash.Strategy<ItemStack> ITEM_STACK_HASH_STRATEGY;

    default public void create$setStack(int slot, ItemStack stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int create$size() {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int create$getMaxCount(ItemStack stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public ItemStack create$getStack(int slot) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public boolean create$isValid(int slot, ItemStack stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public void create$markDirty() {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int count(ItemStack stack, Direction side) {
        return this.count(stack);
    }

    default public int count(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount);
    }

    default public int count(ItemStack stack, int maxAmount, Direction side) {
        return this.count(stack, maxAmount);
    }

    default public int count(ItemStack stack, int maxAmount) {
        int count = 0;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty() || !this.matches(target, stack) || (count += target.getCount()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public ItemStack count(Predicate<ItemStack> predicate, Direction side) {
        return this.count(predicate);
    }

    default public ItemStack count(Predicate<ItemStack> predicate) {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.create$getStack(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            return this.onExtract(stack);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack count(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        return this.count(predicate, maxAmount);
    }

    default public ItemStack count(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.create$getStack(i);
            if (findStack.isEmpty() || !predicate.test(findStack)) continue;
            int count = findStack.getCount();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                ItemStack stack = this.create$getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack) && (count += stack.getCount()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return ItemStack.EMPTY;
    }

    default public int countAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        return this.countAll(predicate, maxAmount);
    }

    default public int countAll(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.create$getStack(i);
            if (stack.isEmpty() || !predicate.test(stack) || (count += stack.getCount()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public ItemStack countAny(Direction side) {
        return this.countAny();
    }

    default public ItemStack countAny() {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) continue;
            return this.onExtract(this.directCopy(target, target.getCount()));
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack countAny(int maxAmount, Direction side) {
        return this.extractAny(maxAmount);
    }

    default public ItemStack countAny(int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.create$getStack(i);
            if (findStack.isEmpty()) continue;
            int count = findStack.getCount();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                ItemStack stack = this.create$getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack) && (count += stack.getCount()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return ItemStack.EMPTY;
    }

    default public int countSpace(ItemStack stack, Direction side) {
        return this.countSpace(stack);
    }

    default public int countSpace(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount);
    }

    default public int countSpace(ItemStack stack, int maxAmount, Direction side) {
        return this.countSpace(stack, maxAmount);
    }

    default public int countSpace(ItemStack stack, int maxAmount) {
        int count = 0;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target;
            if (!this.create$isValid(i, stack) || !((target = this.create$getStack(i)).isEmpty() ? (count += this.create$getMaxCount(stack)) >= maxAmount : this.matches(target, stack) && (count += target.getMaxStackSize() - target.getCount()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public int countSpace(ItemStack stack, int maxAmount, int start, int end, Direction side) {
        return this.countSpace(stack, maxAmount, start, end);
    }

    default public int countSpace(ItemStack stack, int maxAmount, int start, int end) {
        int count = 0;
        for (int i = start; i <= end; ++i) {
            ItemStack target;
            if (!this.create$isValid(i, stack) || !((target = this.create$getStack(i)).isEmpty() ? (count += this.create$getMaxCount(stack)) >= maxAmount : this.matches(target, stack) && (count += target.getMaxStackSize() - target.getCount()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public boolean countSpace(List<ItemStack> stacks, Direction side) {
        return this.countSpace(stacks);
    }

    default public boolean countSpace(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            ItemStack stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.getCount()) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue()) == count;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$isValid(i, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.create$getMaxCount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean countSpace(List<ItemStack> stacks, int start, int end, Direction side) {
        return this.countSpace(stacks, start, end);
    }

    default public boolean countSpace(List<ItemStack> stacks, int start, int end) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            ItemStack stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.getCount(), start, end) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue(), start, end) == count;
        }
        for (int i = start; i <= end; ++i) {
            ItemStack target = this.create$getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$isValid(i, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.create$getMaxCount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public ItemStack directCopy(ItemStack stack, int count) {
        if (!2.$assertionsDisabled && stack.item == null) {
            throw new AssertionError();
        }
        ItemStack copy = new ItemStack((ItemLike)stack.item, count, stack.components.copy());
        copy.setPopTime(stack.getPopTime());
        return copy;
    }

    default public int extract(ItemStack stack, Direction side) {
        return this.extract(stack);
    }

    default public int extract(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount);
    }

    default public int extract(ItemStack stack, int maxAmount, Direction side) {
        return this.extract(stack, maxAmount);
    }

    default public int extract(ItemStack stack, int maxAmount) {
        int remaining = maxAmount;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty() || !this.matches(target, stack)) continue;
            int count = target.getCount();
            if (count > remaining) {
                target.setCount(count - remaining);
                this.create$markDirty();
                return maxAmount;
            }
            this.create$setStack(i, ItemStack.EMPTY);
            if (count == remaining) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= count;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public ItemStack extract(Predicate<ItemStack> predicate, Direction side) {
        return this.extract(predicate);
    }

    default public ItemStack extract(Predicate<ItemStack> predicate) {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty() || !predicate.test(target)) continue;
            this.create$setStack(i, ItemStack.EMPTY);
            this.create$markDirty();
            return this.onExtract(target);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        return this.extract(predicate, maxAmount);
    }

    default public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.create$getStack(i);
            if (findStack.isEmpty() || !predicate.test(findStack)) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                this.create$markDirty();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.create$setStack(i, ItemStack.EMPTY);
            if (count == maxAmount) {
                this.create$markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                ItemStack stack = this.create$getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack)) {
                    count = stack.getCount();
                    if (count < remaining) {
                        this.create$setStack(i, ItemStack.EMPTY);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.create$setStack(i, ItemStack.EMPTY);
                        } else {
                            stack.setCount(count - remaining);
                        }
                        this.create$markDirty();
                        findStack.setCount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.create$markDirty();
            findStack.setCount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return ItemStack.EMPTY;
    }

    default public List<ItemStack> extract(List<ItemStack> stacks, Direction side) {
        return this.extract(stacks);
    }

    default public List<ItemStack> extract(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int extract;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (extract = this.extract(stack))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int extract;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (extract = this.extract(stack, count))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        boolean dirty = false;
        int size = this.create$size();
        block1: for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) continue;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int remaining;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.matches(target, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                int count = target.getCount();
                if (count < (remaining = entry.getIntValue())) {
                    this.create$setStack(i, ItemStack.EMPTY);
                    entry.setValue(remaining - count);
                    continue block1;
                }
                if (count == remaining) {
                    this.create$setStack(i, ItemStack.EMPTY);
                } else {
                    target.setCount(count - remaining);
                }
                iterator.remove();
                if (entries.isEmpty()) {
                    this.create$markDirty();
                    return List.of();
                }
                dirty = true;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (stack.getCount() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.create$markDirty();
            return result;
        }
        return stacks;
    }

    default public int extractAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        return this.extractAll(predicate, maxAmount);
    }

    default public int extractAll(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.create$getStack(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            int count = stack.getCount();
            if (count < remaining) {
                this.create$setStack(i, ItemStack.EMPTY);
                remaining -= count;
                continue;
            }
            if (count == remaining) {
                this.create$setStack(i, ItemStack.EMPTY);
            } else {
                stack.setCount(count - remaining);
            }
            this.create$markDirty();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public ItemStack extractAny(Direction side) {
        return this.extractAny();
    }

    default public ItemStack extractAny() {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) continue;
            this.create$setStack(i, ItemStack.EMPTY);
            this.create$markDirty();
            return this.onExtract(target);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack extractAny(int maxAmount, Direction side) {
        return this.extractAny(maxAmount);
    }

    default public ItemStack extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.create$getStack(i);
            if (findStack.isEmpty()) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                this.create$markDirty();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.create$setStack(i, ItemStack.EMPTY);
            if (count == maxAmount) {
                this.create$markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                ItemStack stack = this.create$getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack)) {
                    count = stack.getCount();
                    if (count < remaining) {
                        this.create$setStack(i, ItemStack.EMPTY);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.create$setStack(i, ItemStack.EMPTY);
                        } else {
                            stack.setCount(count - remaining);
                        }
                        this.create$markDirty();
                        findStack.setCount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.create$markDirty();
            findStack.setCount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return ItemStack.EMPTY;
    }

    default public int forceInsert(ItemStack stack) {
        return this.insert(stack);
    }

    default public int forceInsert(ItemStack stack, int maxAmount) {
        return this.insert(stack, maxAmount);
    }

    default public boolean forcePreciseInsert(ItemStack stack) {
        return this.preciseInsert(stack);
    }

    default public boolean forcePreciseInsert(ItemStack stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount);
    }

    default public int insert(ItemStack stack, Direction side) {
        return this.insert(stack);
    }

    default public int insert(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount);
    }

    default public int insert(ItemStack stack, int maxAmount, Direction side) {
        return this.insert(stack, maxAmount);
    }

    default public int insert(ItemStack stack, int maxAmount) {
        int remaining = maxAmount;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) {
                int insert = Math.min(remaining, this.create$getMaxCount(stack));
                this.create$setStack(i, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.create$markDirty();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public int insert(ItemStack stack, int maxAmount, int start, int end, Direction side) {
        return this.insert(stack, maxAmount, start, end);
    }

    default public int insert(ItemStack stack, int maxAmount, int start, int end) {
        int remaining = maxAmount;
        for (int i = start; i < end; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) {
                int insert = Math.min(remaining, this.create$getMaxCount(stack));
                this.create$setStack(i, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.create$markDirty();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public List<ItemStack> insert(List<ItemStack> stacks, Direction side) {
        return this.insert(stacks);
    }

    default public List<ItemStack> insert(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (insert = this.insert(stack))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        int size = this.create$size();
        block1: for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$isValid(i, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.create$getMaxCount(stack));
                    this.create$setStack(i, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.create$markDirty();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.setCount(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.create$markDirty();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (stack.getCount() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.create$markDirty();
            return result;
        }
        return stacks;
    }

    default public List<ItemStack> insert(List<ItemStack> stacks, int start, int end, Direction side) {
        return this.insert(stacks, start, end);
    }

    default public List<ItemStack> insert(List<ItemStack> stacks, int start, int end) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (insert = this.insert(stack, count, start, end))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count, start, end))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        block1: for (int i = start; i < end; ++i) {
            ItemStack target = this.create$getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$isValid(i, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.create$getMaxCount(stack));
                    this.create$setStack(i, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.create$markDirty();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.setCount(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.create$markDirty();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (stack.getCount() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.create$markDirty();
            return result;
        }
        return stacks;
    }

    default public int insertExist(ItemStack stack, Direction side) {
        return this.insertExist(stack);
    }

    default public int insertExist(ItemStack stack, int maxAmount, Direction side) {
        return this.insertExist(stack);
    }

    default public int insertExist(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insertExist(stack, maxAmount);
    }

    default public int insertExist(ItemStack stack, int maxAmount) {
        int remaining = maxAmount;
        ArrayList<Integer> emptys = new ArrayList<Integer>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) {
                emptys.add(i);
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        Iterator iterator = emptys.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int insert = Math.min(remaining, this.create$getMaxCount(stack));
            this.create$setStack(i, this.directCopy(stack, insert));
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    @NotNull
    default public Iterator<ItemStack> iterator(Direction side) {
        return this.iterator();
    }

    default public boolean matches(ItemStack stack, ItemStack otherStack) {
        if (stack.is(otherStack.getItem())) {
            PatchedDataComponentMap stackComponents = stack.components;
            PatchedDataComponentMap otherStackComponents = otherStack.components;
            if (stackComponents == otherStackComponents) {
                return true;
            }
            Reference2ObjectMap stackComponentMap = stackComponents.patch;
            Reference2ObjectMap otherStackComponentMap = otherStackComponents.patch;
            if (stackComponentMap == otherStackComponentMap) {
                return true;
            }
            int stackComponentCount = stackComponentMap.size();
            if (stackComponentMap.containsKey((Object)DataComponents.MAX_STACK_SIZE)) {
                --stackComponentCount;
            }
            int otherStackComponentCount = otherStackComponentMap.size();
            boolean hasMaxCapacityComponent = false;
            if (otherStackComponentMap.containsKey((Object)DataComponents.MAX_STACK_SIZE)) {
                --otherStackComponentCount;
                hasMaxCapacityComponent = true;
            }
            if (stackComponentCount != otherStackComponentCount) {
                return false;
            }
            if (hasMaxCapacityComponent) {
                ObjectSet stackComponentSet = stackComponentMap.reference2ObjectEntrySet();
                for (Reference2ObjectMap.Entry componentEntry : otherStackComponentMap.reference2ObjectEntrySet()) {
                    if (stackComponentSet.contains((Object)componentEntry) || componentEntry.getKey() == DataComponents.MAX_STACK_SIZE) continue;
                    return false;
                }
                return true;
            }
            return stackComponentMap.reference2ObjectEntrySet().containsAll((Collection)otherStackComponentMap.reference2ObjectEntrySet());
        }
        return false;
    }

    default public ItemStack onExtract(ItemStack stack) {
        return stack;
    }

    default public boolean preciseExtract(ItemStack stack, Direction side) {
        return this.preciseExtract(stack);
    }

    default public boolean preciseExtract(ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        int remaining = stack.getCount();
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty() || !this.matches(target, stack)) continue;
            int count = target.getCount();
            if (count > remaining) {
                changes.forEach(Runnable::run);
                target.setCount(count - remaining);
                this.create$markDirty();
                return true;
            }
            if (count == remaining) {
                changes.forEach(Runnable::run);
                this.create$setStack(i, ItemStack.EMPTY);
                this.create$markDirty();
                return true;
            }
            int slot = i;
            changes.add(() -> this.create$setStack(slot, ItemStack.EMPTY));
            remaining -= count;
        }
        return false;
    }

    default public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        return this.preciseExtract(predicate, maxAmount);
    }

    default public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.create$size();
        ArrayList<Integer> buffer = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.create$getStack(i);
            if (findStack.isEmpty() || !predicate.test(findStack)) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                this.create$markDirty();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            if (count == maxAmount) {
                this.create$setStack(i, ItemStack.EMPTY);
                this.create$markDirty();
                return this.onExtract(findStack);
            }
            buffer.add(i);
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                ItemStack stack = this.create$getStack(i);
                if (!stack.isEmpty() && this.matches(stack, findStack)) {
                    count = stack.getCount();
                    if (count < remaining) {
                        buffer.add(i);
                        remaining -= count;
                    } else {
                        buffer.forEach(slot -> this.create$setStack((int)slot, ItemStack.EMPTY));
                        if (count == remaining) {
                            this.create$setStack(i, ItemStack.EMPTY);
                        } else {
                            stack.setCount(count - remaining);
                        }
                        this.create$markDirty();
                        findStack.setCount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
        }
        return ItemStack.EMPTY;
    }

    default public boolean preciseInsert(ItemStack stack, Direction side) {
        return this.preciseInsert(stack);
    }

    default public boolean preciseInsert(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount);
    }

    default public boolean preciseInsert(ItemStack stack, int maxAmount, Direction side) {
        return this.preciseInsert(stack, maxAmount);
    }

    default public boolean preciseInsert(ItemStack stack, int maxAmount) {
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            ItemStack target = this.create$getStack(i);
            if (target.isEmpty()) {
                int insert = Math.min(maxAmount, this.create$getMaxCount(stack));
                if (maxAmount == insert) {
                    changes.forEach(Runnable::run);
                    this.create$setStack(i, this.directCopy(stack, insert));
                    this.create$markDirty();
                    return true;
                }
                int slot = i;
                changes.add(() -> this.create$setStack(slot, this.directCopy(stack, insert)));
                maxAmount -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(maxAmount, maxCount - count);
            if (maxAmount == insert) {
                changes.forEach(Runnable::run);
                target.setCount(count + insert);
                this.create$markDirty();
                return true;
            }
            changes.add(() -> target.setCount(count + insert));
            maxAmount -= insert;
        }
        return false;
    }

    default public boolean preciseInsert(List<ItemStack> stacks, Direction side) {
        return this.preciseInsert(stacks);
    }

    default public boolean preciseInsert(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((ItemStack)entry.getKey(), entry.getIntValue());
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack target = this.create$getStack(i);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$isValid(i, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.create$getMaxCount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        changes.forEach(Runnable::run);
                        this.create$setStack(i, this.directCopy(stack, insert2));
                        this.create$markDirty();
                        return true;
                    }
                    int slot = i;
                    changes.add(() -> this.create$setStack(slot, this.directCopy(stack, insert2)));
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    changes.forEach(Runnable::run);
                    target.setCount(count + insert);
                    this.create$markDirty();
                    return true;
                }
                changes.add(() -> target.setCount(count + insert));
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean update(Predicate<ItemStack> predicate, Function<ItemStack, ItemStack> update, Direction side) {
        return this.update(predicate, update);
    }

    default public boolean update(Predicate<ItemStack> predicate, Function<ItemStack, ItemStack> update) {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.create$getStack(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            ItemStack replace = update.apply(stack);
            if (replace != stack) {
                this.create$setStack(i, replace);
            }
            this.create$markDirty();
            return true;
        }
        return false;
    }

    default public ItemStack removeMaxSize(ItemStack stack, Optional<Integer> max) {
        PatchedDataComponentMap components = stack.components;
        components.ensureMapOwnership();
        components.patch.remove((Object)DataComponents.MAX_STACK_SIZE, max);
        return stack;
    }

    default public void setMaxSize(ItemStack stack, Optional<Integer> max) {
        PatchedDataComponentMap components = stack.components;
        components.ensureMapOwnership();
        components.patch.put((Object)DataComponents.MAX_STACK_SIZE, max);
    }

    default public Stream<ItemStack> stream(Direction side) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(side), 16), false);
    }

    default public Stream<ItemStack> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        ITEM_STACK_HASH_STRATEGY = new Hash.Strategy<ItemStack>(){

            public boolean equals(ItemStack stack, ItemStack other) {
                return stack == other || stack != null && other != null && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)other);
            }

            public int hashCode(ItemStack stack) {
                return ItemStack.hashItemAndComponents((ItemStack)stack);
            }
        };
    }
}

