/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BaseSidedInventory
extends Container {
    default public int[] create$getAvailableSlots(Direction side) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public boolean create$canInsert(int slot, ItemStack stack, @Nullable Direction dir) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public boolean create$canExtract(int slot, ItemStack stack, Direction dir) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int count(ItemStack stack) {
        return this.count(stack, null);
    }

    default public int count(ItemStack stack, Direction side) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount, side);
    }

    default public int count(ItemStack stack, int maxAmount) {
        return this.count(stack, maxAmount, null);
    }

    default public int count(ItemStack stack, int maxAmount, Direction side) {
        int count = 0;
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target;
            if (!this.create$canExtract(slot, stack, side) || (target = this.getItem(slot)).isEmpty() || !this.matches(target, stack) || (count += target.getCount()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public ItemStack count(Predicate<ItemStack> predicate) {
        return this.count(predicate, null);
    }

    default public ItemStack count(Predicate<ItemStack> predicate, Direction side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || !this.create$canExtract(slot, stack, side) || !predicate.test(stack)) continue;
            return this.onExtract(stack);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack count(Predicate<ItemStack> predicate, int maxAmount) {
        return this.count(predicate, maxAmount, null);
    }

    default public ItemStack count(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            ItemStack findStack = this.getItem(slot);
            if (findStack.isEmpty() || !this.create$canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int count = findStack.getCount();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                slot = slots[i];
                ItemStack stack = this.getItem(slot);
                if (!stack.isEmpty() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack) && (count += stack.getCount()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return ItemStack.EMPTY;
    }

    default public int countAll(Predicate<ItemStack> predicate, int maxAmount) {
        return this.countAll(predicate, maxAmount, null);
    }

    default public int countAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || !predicate.test(stack) || !this.create$canExtract(slot, stack, side) || (count += stack.getCount()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public ItemStack countAny() {
        return this.countAny(null);
    }

    default public ItemStack countAny(Direction side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target = this.getItem(slot);
            if (target.isEmpty() || !this.create$canExtract(slot, target, side)) continue;
            return this.onExtract(this.directCopy(target, target.getCount()));
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack countAny(int maxAmount) {
        return this.extractAny(maxAmount, null);
    }

    default public ItemStack countAny(int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            ItemStack findStack = this.getItem(slot);
            if (findStack.isEmpty() || !this.create$canExtract(slot, findStack, side)) continue;
            int count = findStack.getCount();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                slot = slots[i];
                ItemStack stack = this.getItem(slot);
                if (!stack.isEmpty() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack) && (count += stack.getCount()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return ItemStack.EMPTY;
    }

    default public int countSpace(ItemStack stack) {
        return this.countSpace(stack, null);
    }

    default public int countSpace(ItemStack stack, Direction side) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount, side);
    }

    default public int countSpace(ItemStack stack, int maxAmount) {
        return this.countSpace(stack, maxAmount, null);
    }

    default public int countSpace(ItemStack stack, int maxAmount, Direction side) {
        int count = 0;
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target;
            if (!this.create$canInsert(slot, stack, side) || !this.canPlaceItem(slot, stack) || !((target = this.getItem(slot)).isEmpty() ? (count += this.getMaxStackSize(stack) - target.getCount()) >= maxAmount : this.matches(target, stack) && (count += target.getMaxStackSize() - target.getCount()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public int countSpace(ItemStack stack, int maxAmount, int start, int end) {
        return this.countSpace(stack, maxAmount, start, end, null);
    }

    default public int countSpace(ItemStack stack, int maxAmount, int start, int end, Direction side) {
        int count = 0;
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return 0;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return 0;
        }
        for (int i = start; i <= end; ++i) {
            ItemStack target;
            int slot = slots[i];
            if (!this.create$canInsert(slot, stack, side) || !this.canPlaceItem(slot, stack) || !((target = this.getItem(slot)).isEmpty() ? (count += this.getMaxStackSize(stack) - target.getCount()) >= maxAmount : this.matches(target, stack) && (count += target.getMaxStackSize() - target.getCount()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public boolean countSpace(List<ItemStack> stacks) {
        return this.countSpace(stacks, null);
    }

    default public boolean countSpace(List<ItemStack> stacks, Direction side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            ItemStack stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.getCount(), side) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue(), side) == count;
        }
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target = this.getItem(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$canInsert(slot, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.canPlaceItem(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxStackSize(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean countSpace(List<ItemStack> stacks, int start, int end) {
        return this.countSpace(stacks, start, end, null);
    }

    default public boolean countSpace(List<ItemStack> stacks, int start, int end, Direction side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            ItemStack stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.getCount(), start, end, side) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue(), start, end, side) == count;
        }
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return false;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return false;
        }
        for (int i = start; i <= end; ++i) {
            int slot = slots[i];
            ItemStack target = this.getItem(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$canInsert(slot, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.canPlaceItem(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxStackSize(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public int extract(ItemStack stack) {
        return this.extract(stack, null);
    }

    default public int extract(ItemStack stack, Direction side) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount, side);
    }

    default public int extract(ItemStack stack, int maxAmount) {
        return this.extract(stack, maxAmount, null);
    }

    default public int extract(ItemStack stack, int maxAmount, Direction side) {
        int remaining = maxAmount;
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target;
            if (!this.create$canExtract(slot, stack, side) || (target = this.getItem(slot)).isEmpty() || !this.matches(target, stack)) continue;
            int count = target.getCount();
            if (count > remaining) {
                target.setCount(count - remaining);
                this.setChanged();
                return maxAmount;
            }
            this.setItem(slot, ItemStack.EMPTY);
            if (count == remaining) {
                this.setChanged();
                return maxAmount;
            }
            remaining -= count;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.setChanged();
        return maxAmount - remaining;
    }

    default public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount) {
        return this.extract(predicate, maxAmount, null);
    }

    default public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            ItemStack findStack = this.getItem(slot);
            if (findStack.isEmpty() || !this.create$canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                this.setChanged();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.setItem(slot, ItemStack.EMPTY);
            if (count == maxAmount) {
                this.setChanged();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                slot = slots[i];
                ItemStack stack = this.getItem(slot);
                if (!stack.isEmpty() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    count = stack.getCount();
                    if (count < remaining) {
                        this.setItem(slot, ItemStack.EMPTY);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.setItem(slot, ItemStack.EMPTY);
                        } else {
                            stack.setCount(count - remaining);
                        }
                        this.setChanged();
                        findStack.setCount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.setChanged();
            findStack.setCount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack extract(Predicate<ItemStack> predicate) {
        return this.extract(predicate, null);
    }

    default public ItemStack extract(Predicate<ItemStack> predicate, Direction side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || !this.create$canExtract(slot, stack, side) || !predicate.test(stack)) continue;
            this.setItem(slot, ItemStack.EMPTY);
            this.setChanged();
            return this.onExtract(stack);
        }
        return ItemStack.EMPTY;
    }

    default public List<ItemStack> extract(List<ItemStack> stacks) {
        return this.extract(stacks, null);
    }

    default public List<ItemStack> extract(List<ItemStack> stacks, Direction side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int extract;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (extract = this.extract(stack, side))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int extract;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (extract = this.extract(stack, count, side))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        boolean dirty = false;
        block1: for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target = this.getItem(slot);
            if (target.isEmpty() || !this.create$canExtract(slot, target, side)) continue;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int remaining;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.matches(target, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                int count = target.getCount();
                if (count < (remaining = entry.getIntValue())) {
                    this.setItem(slot, ItemStack.EMPTY);
                    entry.setValue(remaining - count);
                    continue block1;
                }
                if (count == remaining) {
                    this.setItem(slot, ItemStack.EMPTY);
                } else {
                    target.setCount(count - remaining);
                }
                iterator.remove();
                if (entries.isEmpty()) {
                    this.setChanged();
                    return List.of();
                }
                dirty = true;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (stack.getCount() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.setChanged();
            return result;
        }
        return stacks;
    }

    default public int extractAll(Predicate<ItemStack> predicate, int maxAmount) {
        return this.extractAll(predicate, maxAmount, null);
    }

    default public int extractAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || !predicate.test(stack) || !this.create$canExtract(slot, stack, side)) continue;
            int count = stack.getCount();
            if (count < remaining) {
                this.setItem(slot, ItemStack.EMPTY);
                remaining -= count;
                continue;
            }
            if (count == remaining) {
                this.setItem(slot, ItemStack.EMPTY);
            } else {
                stack.setCount(count - remaining);
            }
            this.setChanged();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.setChanged();
        return maxAmount - remaining;
    }

    default public ItemStack extractAny() {
        return this.extractAny(null);
    }

    default public ItemStack extractAny(Direction side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target = this.getItem(slot);
            if (target.isEmpty() || !this.create$canExtract(slot, target, side)) continue;
            this.setItem(slot, ItemStack.EMPTY);
            this.setChanged();
            return this.onExtract(target);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack extractAny(int maxAmount) {
        return this.extractAny(maxAmount, null);
    }

    default public ItemStack extractAny(int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            ItemStack findStack = this.getItem(slot);
            if (findStack.isEmpty() || !this.create$canExtract(slot, findStack, side)) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                this.setChanged();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.setItem(slot, ItemStack.EMPTY);
            if (count == maxAmount) {
                this.setChanged();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                slot = slots[i];
                ItemStack stack = this.getItem(slot);
                if (!stack.isEmpty() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    count = stack.getCount();
                    if (count < remaining) {
                        this.setItem(slot, ItemStack.EMPTY);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.setItem(slot, ItemStack.EMPTY);
                        } else {
                            stack.setCount(count - remaining);
                        }
                        this.setChanged();
                        findStack.setCount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.setChanged();
            findStack.setCount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return ItemStack.EMPTY;
    }

    private int findEndIndex(int[] slots, int start, int end) {
        for (int i = slots.length - 1; i >= start; --i) {
            if (slots[i] > end) continue;
            return i;
        }
        return -1;
    }

    private int findStartIndex(int[] slots, int start) {
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            if (slots[i] < start) continue;
            return i;
        }
        return -1;
    }

    default public int insert(ItemStack stack) {
        return this.insert(stack, null);
    }

    default public int insert(ItemStack stack, int maxAmount) {
        return this.insert(stack, maxAmount, null);
    }

    default public int insert(ItemStack stack, Direction side) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount, side);
    }

    default public int insert(ItemStack stack, int maxAmount, Direction side) {
        int remaining = maxAmount;
        for (int slot : this.create$getAvailableSlots(side)) {
            if (!this.create$canInsert(slot, stack, side) || !this.canPlaceItem(slot, stack)) continue;
            ItemStack target = this.getItem(slot);
            if (target.isEmpty()) {
                int insert = Math.min(remaining, this.getMaxStackSize(stack));
                this.setItem(slot, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.setChanged();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.setChanged();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.setChanged();
        return maxAmount - remaining;
    }

    default public int insert(ItemStack stack, int maxAmount, int start, int end) {
        return this.insert(stack, maxAmount, start, end, null);
    }

    default public int insert(ItemStack stack, int maxAmount, int start, int end, Direction side) {
        int remaining = maxAmount;
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return 0;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return 0;
        }
        for (int i = start; i <= end; ++i) {
            int slot = slots[i];
            if (!this.create$canInsert(slot, stack, side) || !this.canPlaceItem(slot, stack)) continue;
            ItemStack target = this.getItem(slot);
            if (target.isEmpty()) {
                int insert = Math.min(remaining, this.getMaxStackSize(stack));
                this.setItem(slot, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.setChanged();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.setChanged();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.setChanged();
        return maxAmount - remaining;
    }

    default public List<ItemStack> insert(List<ItemStack> stacks) {
        return this.insert(stacks, null);
    }

    default public List<ItemStack> insert(List<ItemStack> stacks, Direction side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (insert = this.insert(stack, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        block1: for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target = this.getItem(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$canInsert(slot, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.canPlaceItem(slot, stack)) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.getMaxStackSize(stack));
                    this.setItem(slot, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.setChanged();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.setCount(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.setChanged();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (stack.getCount() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.setChanged();
            return result;
        }
        return stacks;
    }

    default public List<ItemStack> insert(List<ItemStack> stacks, int start, int end) {
        return this.insert(stacks, start, end, null);
    }

    default public List<ItemStack> insert(List<ItemStack> stacks, int start, int end, Direction side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (insert = this.insert(stack, count, start, end, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count, start, end, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return stacks;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return stacks;
        }
        block1: for (int i = start; i <= end; ++i) {
            int slot = slots[i];
            ItemStack target = this.getItem(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$canInsert(slot, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.canPlaceItem(slot, stack)) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.getMaxStackSize(stack));
                    this.setItem(slot, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.setChanged();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.setCount(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.setChanged();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (stack.getCount() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.setChanged();
            return result;
        }
        return stacks;
    }

    default public int insertExist(ItemStack stack) {
        return this.insertExist(stack, null);
    }

    default public int insertExist(ItemStack stack, int maxAmount) {
        return this.insertExist(stack, maxAmount, null);
    }

    default public int insertExist(ItemStack stack, Direction side) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insertExist(stack, maxAmount, side);
    }

    default public int insertExist(ItemStack stack, int maxAmount, Direction side) {
        int remaining = maxAmount;
        ArrayList<Integer> emptys = new ArrayList<Integer>();
        for (int slot : this.create$getAvailableSlots(side)) {
            if (!this.create$canInsert(slot, stack, side) || !this.canPlaceItem(slot, stack)) continue;
            ItemStack target = this.getItem(slot);
            if (target.isEmpty()) {
                emptys.add(slot);
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.setChanged();
                return maxAmount;
            }
            remaining -= insert;
        }
        Object object = emptys.iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            int insert = Math.min(remaining, this.getMaxStackSize(stack));
            this.setItem(slot, this.directCopy(stack, insert));
            if (remaining == insert) {
                this.setChanged();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.setChanged();
        return maxAmount - remaining;
    }

    @NotNull
    default public java.util.Iterator<ItemStack> iterator() {
        return this.iterator(null);
    }

    @NotNull
    default public java.util.Iterator<ItemStack> iterator(Direction side) {
        return new Iterator(this, side);
    }

    default public boolean preciseExtract(ItemStack stack) {
        return this.preciseExtract(stack, null);
    }

    default public boolean preciseExtract(ItemStack stack, Direction side) {
        if (stack.isEmpty()) {
            return true;
        }
        int remaining = stack.getCount();
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target;
            if (!this.create$canExtract(slot, stack, side) || (target = this.getItem(slot)).isEmpty() || !this.matches(target, stack)) continue;
            int count = target.getCount();
            if (count > remaining) {
                changes.forEach(Runnable::run);
                target.setCount(count - remaining);
                this.setChanged();
                return true;
            }
            if (count == remaining) {
                changes.forEach(Runnable::run);
                this.setItem(slot, ItemStack.EMPTY);
                this.setChanged();
                return true;
            }
            changes.add(() -> this.setItem(slot, ItemStack.EMPTY));
            remaining -= count;
        }
        return false;
    }

    default public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount) {
        return this.preciseExtract(predicate, maxAmount, null);
    }

    default public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        ArrayList<Integer> buffer = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            ItemStack findStack = this.getItem(slot);
            if (findStack.isEmpty() || !this.create$canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                this.setChanged();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            if (count == maxAmount) {
                this.setItem(slot, ItemStack.EMPTY);
                this.setChanged();
                return this.onExtract(findStack);
            }
            buffer.add(slot);
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                slot = slots[i];
                ItemStack stack = this.getItem(slot);
                if (!stack.isEmpty() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    count = stack.getCount();
                    if (count < remaining) {
                        buffer.add(slot);
                        remaining -= count;
                    } else {
                        buffer.forEach(j -> this.setItem((int)j, ItemStack.EMPTY));
                        if (count == remaining) {
                            this.setItem(slot, ItemStack.EMPTY);
                        } else {
                            stack.setCount(count - remaining);
                        }
                        this.setChanged();
                        findStack.setCount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
        }
        return ItemStack.EMPTY;
    }

    default public boolean preciseInsert(ItemStack stack) {
        return this.preciseInsert(stack, null);
    }

    default public boolean preciseInsert(ItemStack stack, Direction side) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount, side);
    }

    default public boolean preciseInsert(ItemStack stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount, null);
    }

    default public boolean preciseInsert(ItemStack stack, int maxAmount, Direction side) {
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.create$getAvailableSlots(side)) {
            if (!this.create$canInsert(slot, stack, side) || !this.canPlaceItem(slot, stack)) continue;
            ItemStack target = this.getItem(slot);
            if (target.isEmpty()) {
                int insert = Math.min(maxAmount, this.getMaxStackSize(stack));
                if (maxAmount == insert) {
                    changes.forEach(Runnable::run);
                    this.setItem(slot, this.directCopy(stack, insert));
                    this.setChanged();
                    return true;
                }
                changes.add(() -> this.setItem(slot, this.directCopy(stack, insert)));
                maxAmount -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxStackSize();
            int count = target.getCount();
            if (count == maxCount) continue;
            int insert = Math.min(maxAmount, maxCount - count);
            if (maxAmount == insert) {
                changes.forEach(Runnable::run);
                target.setCount(count + insert);
                this.setChanged();
                return true;
            }
            changes.add(() -> target.setCount(count + insert));
            maxAmount -= insert;
        }
        return false;
    }

    default public boolean preciseInsert(List<ItemStack> stacks) {
        return this.preciseInsert(stacks, null);
    }

    default public boolean preciseInsert(List<ItemStack> stacks, Direction side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst(), side);
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((ItemStack)entry.getKey(), entry.getIntValue(), side);
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack target = this.getItem(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                ItemStack stack;
                if (!this.create$canInsert(slot, stack = (ItemStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.canPlaceItem(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxStackSize(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        changes.forEach(Runnable::run);
                        this.setItem(slot, this.directCopy(stack, insert2));
                        this.setChanged();
                        return true;
                    }
                    changes.add(() -> this.setItem(slot, this.directCopy(stack, insert2)));
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.getMaxStackSize();
                int count = target.getCount();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    changes.forEach(Runnable::run);
                    target.setCount(count + insert);
                    this.setChanged();
                    return true;
                }
                changes.add(() -> target.setCount(count + insert));
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean update(Predicate<ItemStack> predicate, Function<ItemStack, ItemStack> update) {
        return this.update(predicate, update, null);
    }

    default public boolean update(Predicate<ItemStack> predicate, Function<ItemStack, ItemStack> update, Direction side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || !predicate.test(stack) || !this.create$canExtract(slot, stack, side)) continue;
            ItemStack replace = update.apply(stack);
            if (replace != stack) {
                this.setItem(slot, replace);
            }
            this.setChanged();
            return true;
        }
        return false;
    }

    public static class Iterator
    implements java.util.Iterator<ItemStack> {
        private final BaseSidedInventory inventory;
        private final Direction side;
        private final int[] slots;
        private int index;
        private int current = -1;

        public Iterator(BaseSidedInventory inventory, Direction side) {
            this.inventory = inventory;
            this.side = side;
            this.slots = inventory.create$getAvailableSlots(side);
        }

        @Override
        public boolean hasNext() {
            if (this.current >= 0) {
                return true;
            }
            if (this.current == -2) {
                return false;
            }
            while (this.index < this.slots.length) {
                ItemStack stack = this.inventory.getItem(this.slots[this.index]);
                if (this.inventory.create$canExtract(this.index, stack, this.side)) {
                    this.current = this.index++;
                    return true;
                }
                ++this.index;
            }
            this.current = -2;
            return false;
        }

        @Override
        public ItemStack next() {
            if (this.hasNext()) {
                ItemStack result = this.inventory.getItem(this.slots[this.current]);
                this.current = -1;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

