/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedInvWrapper
implements SidedItemInventory {
    protected final Container[] itemHandler;
    protected final int[] baseIndex;
    private final boolean[] sideInventory;
    protected final int[] slots;

    public CombinedInvWrapper(Container ... itemHandler) {
        this.itemHandler = itemHandler;
        int length = itemHandler.length;
        this.baseIndex = new int[length];
        this.sideInventory = new boolean[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            Container inventory = itemHandler[i];
            this.baseIndex[i] = index += inventory.getContainerSize();
            this.sideInventory[i] = inventory instanceof WorldlyContainer;
        }
        this.slots = SlotRangeCache.get(index);
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    protected Container getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.itemHandler.length) {
            return null;
        }
        return this.itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    public int[] getSlotsForFace(Direction side) {
        return this.slots;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        int index = this.getIndexForSlot(slot);
        Container handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (handler.canPlaceItem(slot, stack)) {
            if (this.sideInventory[index]) {
                return ((WorldlyContainer)handler).canPlaceItemThroughFace(slot, stack, dir);
            }
            return true;
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        int index = this.getIndexForSlot(slot);
        Container handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (this.sideInventory[index]) {
            return ((WorldlyContainer)handler).canTakeItemThroughFace(slot, stack, dir);
        }
        return true;
    }

    public int getContainerSize() {
        return this.slots.length;
    }

    public ItemStack getItem(int slot) {
        int index = this.getIndexForSlot(slot);
        Container handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        slot = this.getSlotFromIndex(slot, index);
        return handler.getItem(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        int index = this.getIndexForSlot(slot);
        Container handler = this.getHandlerFromIndex(index);
        if (handler == null) {
            return;
        }
        slot = this.getSlotFromIndex(slot, index);
        handler.setItem(slot, stack);
    }

    public int insert(ItemStack stack, int maxAmount, Direction side) {
        int remaining = maxAmount;
        for (Container handler : this.itemHandler) {
            int insert = handler.insert(stack, remaining, side);
            if (remaining == insert) {
                this.markInventoryDirty();
                return maxAmount;
            }
            if (insert == 0) continue;
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public int extract(ItemStack stack, int maxAmount, Direction side) {
        int remaining = maxAmount;
        for (Container handler : this.itemHandler) {
            int extract = handler.extract(stack, remaining, side);
            if (remaining == extract) {
                this.markInventoryDirty();
                return maxAmount;
            }
            if (extract == 0) continue;
            remaining -= extract;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.itemHandler.length;
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.itemHandler[i].extract(predicate, maxAmount, side);
            if (findStack == ItemStack.EMPTY) continue;
            int extract = findStack.getCount();
            if (extract == maxAmount) {
                this.markInventoryDirty();
                return findStack;
            }
            if (++i == size) {
                this.markInventoryDirty();
                return findStack;
            }
            int remaining = maxAmount - extract;
            while (i < size) {
                extract = this.itemHandler[i].extract(findStack, remaining, side);
                if (remaining == extract) {
                    this.markInventoryDirty();
                    findStack.setCount(maxAmount);
                    return findStack;
                }
                if (extract != 0) {
                    remaining -= extract;
                }
                ++i;
            }
            this.markInventoryDirty();
            findStack.setCount(maxAmount - remaining);
            return findStack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int size = this.itemHandler.length;
        for (int i = 0; i < size; ++i) {
            ItemStack findStack = this.itemHandler[i].count(predicate, maxAmount, side);
            if (findStack.isEmpty()) continue;
            int count = findStack.getCount();
            if (count == maxAmount) {
                this.itemHandler[i].extract(findStack, count, side);
                this.markInventoryDirty();
                return findStack;
            }
            if (++i == size) break;
            int[] extracts = new int[size];
            extracts[i] = count;
            int remaining = maxAmount - count;
            while (i < size) {
                int extract = this.itemHandler[i].count(findStack, remaining, side);
                if (extract != 0) {
                    extracts[i] = extract;
                    if (remaining > extract) {
                        remaining -= extract;
                    } else {
                        for (int j = 0; j <= i; ++j) {
                            extract = extracts[j];
                            if (extract == 0) continue;
                            this.itemHandler[j].extract(findStack, extract, side);
                        }
                        this.markInventoryDirty();
                        findStack.setCount(maxAmount);
                        return findStack;
                    }
                }
                ++i;
            }
        }
        return ItemStack.EMPTY;
    }

    public int countAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (Container inventory : this.itemHandler) {
            if ((count += inventory.countAll(predicate, maxAmount, side)) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    public int extractAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (Container inventory : this.itemHandler) {
            int extract = inventory.extractAll(predicate, remaining, side);
            if (extract < remaining) {
                remaining -= extract;
                continue;
            }
            this.markInventoryDirty();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markInventoryDirty();
        return maxAmount - remaining;
    }

    public void markInventoryDirty() {
    }

    @Override
    public void setChanged() {
        for (Container inventory : this.itemHandler) {
            inventory.setChanged();
        }
        this.markInventoryDirty();
    }

    @NotNull
    public java.util.Iterator<ItemStack> iterator(Direction side) {
        if (this.itemHandler.length == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator(side);
    }

    class Iterator
    implements java.util.Iterator<ItemStack> {
        private int index;
        private final Direction side;
        private java.util.Iterator<ItemStack> iterator;

        public Iterator(Direction side) {
            this.side = side;
            this.iterator = CombinedInvWrapper.this.itemHandler[this.index].iterator(side);
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            do {
                ++this.index;
                if (this.index >= CombinedInvWrapper.this.itemHandler.length) {
                    return false;
                }
                this.iterator = CombinedInvWrapper.this.itemHandler[this.index].iterator(this.side);
            } while (!this.iterator.hasNext());
            return true;
        }

        @Override
        public ItemStack next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }
    }
}

