/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface ItemInventory
extends Container {
    default public ItemStack removeItem(int slot, int amount) {
        if (slot >= this.getContainerSize() || amount <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.getItem(slot);
        int count = stack.getCount();
        if (count == 0) {
            return stack;
        }
        if (amount >= count) {
            this.setItem(slot, ItemStack.EMPTY);
            return this.onExtract(stack);
        }
        if (!1.$assertionsDisabled && stack.item == null) {
            throw new AssertionError();
        }
        ItemStack extract = new ItemStack((ItemLike)stack.item, amount, stack.components.copy());
        extract.setPopTime(stack.getPopTime());
        stack.setCount(count - amount);
        return this.onExtract(extract);
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.getItem(slot);
        if (stack.isEmpty()) {
            return stack;
        }
        this.setItem(slot, ItemStack.EMPTY);
        return this.onExtract(stack);
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public boolean isEmpty() {
        int size = this.getContainerSize();
        for (int i = 0; i < size; ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public void clearContent() {
        int size = this.getContainerSize();
        for (int i = 0; i < size; ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }

    default public void setChanged() {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

