/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemStackHandler
implements ItemInventory {
    public static final Codec<ItemStackHandler> CODEC = Codec.of(ItemStackHandler::encode, ItemStackHandler::decode);
    protected final NonNullList<ItemStack> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public ItemStack getItem(int slot) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= this.getContainerSize()) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public void writeSlots(ValueOutput view) {
        view.store("Inventory", CreateCodecs.ITEM_LIST_CODEC, this.stacks);
    }

    public void readSlots(ValueInput view) {
        view.read("Inventory", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(list -> {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                this.stacks.set(i, (Object)((ItemStack)list.get(i)));
            }
        }, () -> this.stacks.clear());
    }

    public void write(ValueOutput view) {
        ValueOutput.TypedOutputList list = view.list("Inventory", ItemStack.CODEC);
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            list.add((Object)stack);
        }
    }

    public void read(ValueInput view) {
        ValueInput.TypedInputList list = view.listOrEmpty("Inventory", ItemStack.CODEC);
        int i = 0;
        for (ItemStack itemStack : list) {
            this.stacks.set(i++, (Object)itemStack);
        }
        int size = this.stacks.size();
        while (i < size) {
            this.stacks.set(i, (Object)ItemStack.EMPTY);
            ++i;
        }
    }

    private static <T> DataResult<T> encode(ItemStackHandler input, DynamicOps<T> ops, T prefix) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Size", ops.createInt(input.stacks.size()));
        ListBuilder list = ops.listBuilder();
        for (ItemStack stack : input.stacks) {
            if (stack.isEmpty()) continue;
            list.add(ItemStack.CODEC.encodeStart(ops, (Object)stack));
        }
        map.add("Stacks", list.build(ops.empty()));
        return map.build(prefix);
    }

    private static <T> DataResult<Pair<ItemStackHandler, T>> decode(DynamicOps<T> ops, T input) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        int size = ((Number)ops.getNumberValue(map.get("Size")).getOrThrow()).intValue();
        ItemStackHandler handler = new ItemStackHandler(size);
        MutableInt i = new MutableInt();
        ((Consumer)ops.getList(map.get("Stacks")).getOrThrow()).accept(item -> handler.stacks.set(i.getAndIncrement(), (Object)ItemStack.CODEC.parse(ops, item).result().orElse(ItemStack.EMPTY)));
        return DataResult.success((Object)Pair.of((Object)handler, (Object)ops.empty()));
    }
}

