/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SidedInventoryWrapper(Container inventory, int[] slots) implements SidedItemInventory
{
    public SidedInventoryWrapper(Container inventory) {
        this(inventory, SlotRangeCache.get(inventory.getContainerSize()));
    }

    public int[] getSlotsForFace(Direction side) {
        return this.slots;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return true;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getItem(slot);
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        return this.inventory.removeItem(slot, amount);
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        return this.inventory.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setItem(slot, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.inventory.getMaxStackSize(stack);
    }

    @Override
    public void setChanged() {
        this.inventory.setChanged();
    }

    @Override
    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void startOpen(ContainerUser player) {
        this.inventory.startOpen(player);
    }

    public void stopOpen(ContainerUser player) {
        this.inventory.stopOpen(player);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.inventory.canPlaceItem(slot, stack);
    }

    public boolean canTakeItem(Container hopperInventory, int slot, ItemStack stack) {
        return this.inventory.canTakeItem(hopperInventory, slot, stack);
    }

    public int countItem(Item item) {
        return this.inventory.countItem(item);
    }

    public boolean hasAnyOf(Set<Item> items) {
        return this.inventory.hasAnyOf(items);
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        return this.inventory.hasAnyMatching(predicate);
    }

    public int insert(ItemStack stack) {
        return this.inventory.insert(stack);
    }

    public int insert(ItemStack stack, Direction side) {
        return this.inventory.insert(stack);
    }

    public boolean preciseInsert(ItemStack stack) {
        return this.inventory.preciseInsert(stack);
    }

    public boolean preciseInsert(ItemStack stack, Direction side) {
        return this.inventory.preciseInsert(stack);
    }

    public int count(ItemStack stack) {
        return this.inventory.count(stack);
    }

    public int count(ItemStack stack, Direction side) {
        return this.inventory.count(stack);
    }

    public int count(ItemStack stack, int maxAmount) {
        return this.inventory.count(stack, maxAmount);
    }

    public int count(ItemStack stack, int maxAmount, Direction side) {
        return this.inventory.count(stack, maxAmount);
    }

    public int countSpace(ItemStack stack) {
        return this.inventory.countSpace(stack);
    }

    public int countSpace(ItemStack stack, Direction side) {
        return this.inventory.countSpace(stack);
    }

    public int countSpace(ItemStack stack, int maxAmount) {
        return this.inventory.countSpace(stack, maxAmount);
    }

    public int countSpace(ItemStack stack, int maxAmount, Direction side) {
        return this.inventory.countSpace(stack, maxAmount);
    }

    public int extract(ItemStack stack) {
        return this.inventory.extract(stack);
    }

    public int extract(ItemStack stack, Direction side) {
        return this.inventory.extract(stack);
    }

    public boolean preciseExtract(ItemStack stack) {
        return this.inventory.preciseExtract(stack);
    }

    public boolean preciseExtract(ItemStack stack, Direction side) {
        return this.inventory.preciseExtract(stack);
    }

    @NotNull
    public Iterator<ItemStack> iterator() {
        return this.inventory.iterator();
    }

    @NotNull
    public Iterator<ItemStack> iterator(Direction side) {
        return this.inventory.iterator();
    }
}

