/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.infrastructure.items.BaseInventory;
import com.zurrtum.create.infrastructure.packet.s2c.S2CPacket;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;

public record BlueprintPreviewPacket(List<ItemStack> available, List<ItemStack> missing, ItemStack result) implements S2CPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, BlueprintPreviewPacket> CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), BlueprintPreviewPacket::available, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), BlueprintPreviewPacket::missing, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BlueprintPreviewPacket::result, BlueprintPreviewPacket::new);
    public static final BlueprintPreviewPacket EMPTY = new BlueprintPreviewPacket(List.of(), List.of(), ItemStack.EMPTY);

    public BlueprintPreviewPacket(Object2IntLinkedOpenCustomHashMap<ItemStack> available, Object2IntLinkedOpenCustomHashMap<ItemStack> missing, ItemStack result) {
        this(BlueprintPreviewPacket.toList(available), BlueprintPreviewPacket.toList(missing), result);
    }

    public BlueprintPreviewPacket(Object2IntLinkedOpenCustomHashMap<ItemStack> available, List<ItemStack> missing, ItemStack result) {
        this(BlueprintPreviewPacket.toList(available), missing, result);
    }

    public static Object2IntLinkedOpenCustomHashMap<ItemStack> createMap() {
        return new Object2IntLinkedOpenCustomHashMap(BaseInventory.ITEM_STACK_HASH_STRATEGY);
    }

    public static Object2IntLinkedOpenCustomHashMap<ItemStack> createMap(Object2IntLinkedOpenCustomHashMap<ItemStack> source) {
        return new Object2IntLinkedOpenCustomHashMap(source, BaseInventory.ITEM_STACK_HASH_STRATEGY);
    }

    private static List<ItemStack> toList(Object2IntLinkedOpenCustomHashMap<ItemStack> map) {
        ObjectBidirectionalIterator iterator = map.object2IntEntrySet().fastIterator();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        while (iterator.hasNext()) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            ItemStack stack = (ItemStack)entry.getKey();
            int maxCount = stack.getMaxStackSize();
            for (count = entry.getIntValue(); count > maxCount; count -= maxCount) {
                result.add(stack.copyWithCount(maxCount));
            }
            result.add(stack.copyWithCount(count));
        }
        return result;
    }

    public <T> TriConsumer<AllClientHandle<T>, T, BlueprintPreviewPacket> callback() {
        return AllClientHandle::onBlueprintPreview;
    }

    public PacketType<BlueprintPreviewPacket> type() {
        return AllPackets.BLUEPRINT_PREVIEW;
    }
}

