/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllPackets;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;

public class EjectorItemSpawnPacket
extends ClientboundAddEntityPacket {
    private final boolean alive;
    private final int progress;
    private final boolean hasLauncher;
    private final EntityLauncher launcher;
    private final Direction direction;
    public static final StreamCodec<RegistryFriendlyByteBuf, EjectorItemSpawnPacket> CODEC = Packet.codec(EjectorItemSpawnPacket::write, EjectorItemSpawnPacket::new);

    public EjectorItemSpawnPacket(EjectorItemEntity entity, ServerEntity entityTrackerEntry) {
        super((Entity)entity, entityTrackerEntry);
        this.alive = entity.isAlive();
        boolean bl = this.hasLauncher = !this.alive && !(entity.level().getBlockEntity(entity.blockPosition()) instanceof EjectorBlockEntity);
        if (this.hasLauncher) {
            this.progress = entity.progress;
            this.launcher = entity.launcher;
            this.direction = entity.direction;
        } else {
            this.progress = 0;
            this.launcher = null;
            this.direction = null;
        }
    }

    private EjectorItemSpawnPacket(RegistryFriendlyByteBuf buf) {
        super(buf);
        this.alive = buf.readBoolean();
        this.progress = buf.readInt();
        if (!this.alive) {
            this.hasLauncher = buf.readBoolean();
            if (this.hasLauncher) {
                this.launcher = (EntityLauncher)EntityLauncher.PACKET_CODEC.decode((Object)buf);
                this.direction = (Direction)Direction.STREAM_CODEC.decode((Object)buf);
                return;
            }
        } else {
            this.hasLauncher = false;
        }
        this.launcher = null;
        this.direction = null;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.alive);
        buf.writeInt(this.progress);
        if (!this.alive) {
            buf.writeBoolean(this.hasLauncher);
            if (this.hasLauncher) {
                EntityLauncher.PACKET_CODEC.encode((Object)buf, (Object)this.launcher);
                Direction.STREAM_CODEC.encode((Object)buf, (Object)this.direction);
            }
        }
    }

    public boolean getAlive() {
        return this.alive;
    }

    public int getProgress() {
        return this.progress;
    }

    public EntityLauncher getLauncher() {
        return this.launcher;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean hasLauncher() {
        return this.hasLauncher;
    }

    public PacketType<ClientboundAddEntityPacket> type() {
        return AllPackets.EJECTOR_ITEM_SPAWN;
    }
}

