/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllPackets;
import com.zurrtum.create.content.contraptions.data.ContraptionSyncLimiting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class NbtSpawnPacket
extends ClientboundAddEntityPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, NbtSpawnPacket> CODEC = Packet.codec(NbtSpawnPacket::write, NbtSpawnPacket::new);
    @Nullable
    private final CompoundTag nbt;

    public NbtSpawnPacket(Entity entity, ServerEntity entityTrackerEntry, CompoundTag nbt) {
        super(entity, entityTrackerEntry);
        this.nbt = nbt;
    }

    private NbtSpawnPacket(RegistryFriendlyByteBuf buf) {
        super(buf);
        Tag tag = buf.readNbt(NbtAccounter.unlimitedHeap());
        this.nbt = tag != null && !(tag instanceof CompoundTag) ? null : (CompoundTag)tag;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        super.write(buf);
        ContraptionSyncLimiting.writeSafe(this.nbt, (FriendlyByteBuf)buf);
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public PacketType<ClientboundAddEntityPacket> type() {
        return AllPackets.NBT_SPAWN;
    }
}

