/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.google.common.collect.MapMaker;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorageImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface FluidInventoryStorage
extends SlottedStorage<FluidVariant> {
    public static final Map<FluidVariant, FluidStack> CACHE = new MapMaker().weakKeys().makeMap();

    public static FluidStack getCachedStack(FluidVariant variant) {
        return CACHE.computeIfAbsent(variant, FluidInventoryStorage::toStack);
    }

    public static FluidStack toStack(FluidVariant variant) {
        return new FluidStack(variant.getFluid(), 1, variant.getComponents());
    }

    public static FluidInventoryStorage of(FluidInventory inventory) {
        Objects.requireNonNull(inventory, "Null fluid inventory is not supported.");
        return FluidInventoryStorageImpl.of(inventory);
    }

    public static FluidInventoryStorage of(FluidInventory inventory, @Nullable Direction direction) {
        Objects.requireNonNull(inventory, "Null fluid inventory is not supported.");
        return FluidInventoryStorageImpl.of(inventory, direction);
    }

    public static boolean matches(FluidVariant variant, FluidStack stack) {
        DataComponentPatch variantComponents;
        if (!variant.isOf((Object)stack.getFluid())) {
            return false;
        }
        DataComponentPatch stackComponents = stack.getComponentChanges();
        if (stackComponents == (variantComponents = variant.getComponents())) {
            return true;
        }
        return stackComponents.map.reference2ObjectEntrySet().containsAll((Collection)variantComponents.map.reference2ObjectEntrySet());
    }

    public @UnmodifiableView List<SingleSlotStorage<FluidVariant>> getSlots();

    default public int getSlotCount() {
        return this.getSlots().size();
    }

    default public SingleSlotStorage<FluidVariant> getSlot(int slot) {
        return this.getSlots().get(slot);
    }

    public static String toString(FluidInventory inventory) {
        if (inventory == null) {
            return "~~NULL~~";
        }
        Object result = inventory.toString();
        if (inventory instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)inventory;
            result = (String)result + " (%s, %s)".formatted(blockEntity.getBlockState(), DebugMessages.forGlobalPos((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos()));
        }
        return result;
    }
}

