/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.material.Fluid;

public abstract class SingleFluidStackStorage
extends SnapshotParticipant<FluidStack>
implements SingleSlotStorage<FluidVariant> {
    protected abstract FluidStack getStack();

    protected abstract void setStack(FluidStack var1);

    protected boolean canInsert(FluidVariant variant) {
        return true;
    }

    protected boolean canExtract(FluidVariant variant) {
        return true;
    }

    public int getCapacity(FluidVariant insert, FluidStack stack) {
        return stack.getMaxAmount();
    }

    public boolean isResourceBlank() {
        return this.getStack().isEmpty();
    }

    public FluidVariant getResource() {
        FluidStack stack = this.getStack();
        return FluidVariant.of((Fluid)stack.getFluid(), (DataComponentPatch)stack.getComponentChanges());
    }

    public long getAmount() {
        return this.getStack().getAmount();
    }

    public long getCapacity() {
        return this.getStack().getMaxAmount();
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        int insertedAmount;
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        FluidStack currentStack = this.getStack();
        if ((FluidInventoryStorage.matches(insertedVariant, currentStack) || currentStack.isEmpty()) && this.canInsert(insertedVariant) && (insertedAmount = (int)Math.min(maxAmount, (long)(this.getCapacity(insertedVariant, currentStack) - currentStack.getAmount()))) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            if (currentStack.isEmpty()) {
                Integer capacity = (Integer)currentStack.get(AllDataComponents.FLUID_MAX_CAPACITY);
                currentStack = new FluidStack(insertedVariant.getFluid(), insertedAmount, insertedVariant.getComponents());
                if (capacity != null) {
                    currentStack.set(AllDataComponents.FLUID_MAX_CAPACITY, capacity);
                }
            } else {
                currentStack.increment(insertedAmount);
            }
            this.setStack(currentStack);
            return insertedAmount;
        }
        return 0L;
    }

    public long extract(FluidVariant variant, long maxAmount, TransactionContext transaction) {
        int extracted;
        StoragePreconditions.notBlankNotNegative((TransferVariant)variant, (long)maxAmount);
        FluidStack currentStack = this.getStack();
        if (FluidInventoryStorage.matches(variant, currentStack) && this.canExtract(variant) && (extracted = (int)Math.min((long)currentStack.getAmount(), maxAmount)) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            currentStack.decrement(extracted);
            this.setStack(currentStack);
            return extracted;
        }
        return 0L;
    }

    protected FluidStack createSnapshot() {
        FluidStack original = this.getStack();
        this.setStack(original.copy());
        return original;
    }

    protected void readSnapshot(FluidStack snapshot) {
        this.setStack(snapshot);
    }

    public String toString() {
        return "SingleFluidStackStorage[" + String.valueOf(this.getStack()) + "]";
    }
}

